var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var AggregatedEvent = (function () {
                function AggregatedEvent() {
                    this._eventListeners = [];
                }
                AggregatedEvent.prototype.invokeEvent = function (args) {
                    this._eventListeners.forEach(function (func) { return func(args); });
                };
                AggregatedEvent.prototype.addEventListener = function (func) {
                    this._eventListeners.push(func);
                };
                AggregatedEvent.prototype.removeEventListener = function (func) {
                    var location = this._eventListeners.indexOf(func);
                    if (location > -1) {
                        this._eventListeners.splice(location, 1);
                    }
                };
                AggregatedEvent.prototype.dispose = function () {
                    this._eventListeners = null;
                };
                return AggregatedEvent;
            }());
            DiagnosticsHub.AggregatedEvent = AggregatedEvent;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var Debug;
            (function (Debug) {
                var Assert = (function () {
                    function Assert() {
                    }
                    Assert.isUndefined = function (val, errorMessage) {
                    };
                    Assert.isNotUndefined = function (val, errorMessage) {
                    };
                    Assert.isNull = function (val, errorMessage) {
                    };
                    Assert.isNotNull = function (val, errorMessage) {
                    };
                    Assert.isTrue = function (val, errorMessage) {
                    };
                    Assert.isFalse = function (val, errorMessage) {
                    };
                    Assert.fail = function (errorMessage) {
                    };
                    Assert.isDebugBuild = function () {
                        return false;
                    };
                    return Assert;
                }());
                Debug.Assert = Assert;
            })(Debug = DiagnosticsHub.Debug || (DiagnosticsHub.Debug = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var Automation = (function () {
                function Automation(logger) {
                    this._postFilters = {};
                    this._preFilters = {};
                    this._alertFilters = {};
                    this._confirmationFilters = {};
                    this._logger = logger;
                }
                Automation.prototype.getAutomationPromise = function (key, promiseFunc, oncancel, args) {
                    var _this = this;
                    var postFilter = this._postFilters[key];
                    var preFilter = this._preFilters[key];
                    var currentPromise = null;
                    if (preFilter) {
                        currentPromise = this.getPreFilterPromise(preFilter, args);
                        if (postFilter) {
                            currentPromise = currentPromise.then(function () {
                                return _this.getPostFilterPromise(postFilter, promiseFunc, oncancel, args);
                            }, function (error) {
                                _this._logger.error("Error '" + JSON.stringify(error) + "' while executing pre-filter'");
                            });
                        }
                        else {
                            currentPromise = currentPromise.then(function () {
                                return new Microsoft.Plugin.Promise(function (comp, err, prog) {
                                    promiseFunc(comp, err, prog, args);
                                }, oncancel);
                            }, function (error) {
                                _this._logger.error("Error '" + JSON.stringify(error) + "' while executing pre-filter'");
                            });
                        }
                    }
                    else {
                        if (postFilter) {
                            currentPromise = this.getPostFilterPromise(postFilter, promiseFunc, oncancel, args);
                        }
                        else {
                            currentPromise = new Microsoft.Plugin.Promise(function (comp, err, prog) {
                                promiseFunc(comp, err, prog, args);
                            }, oncancel);
                        }
                    }
                    return currentPromise;
                };
                Automation.prototype.getAlertPromise = function (key, message) {
                    var alertFilter = this._alertFilters[key];
                    if (!alertFilter) {
                        return new Microsoft.Plugin.Promise(function (comp, err, prog) {
                            window.alert(message);
                            comp(true);
                        });
                    }
                    else {
                        return alertFilter.bypass(message);
                    }
                };
                Automation.prototype.getConfirmationPromise = function (key, message) {
                    var confirmationFilter = this._confirmationFilters[key];
                    if (!confirmationFilter) {
                        return new Microsoft.Plugin.Promise(function (comp, err, prog) {
                            comp(window.confirm(message));
                        });
                    }
                    else {
                        return confirmationFilter.bypass(message);
                    }
                };
                Automation.prototype.addAutomationPostFilter = function (key, filter) {
                    this.addAutomationFilter(this._postFilters, key, "IAutomationPostFilter", filter);
                };
                Automation.prototype.removeAutomationPostFilter = function (key) {
                    this.removeAutomationFilter(this._postFilters, key, "IAutomationPostFilter");
                };
                Automation.prototype.addAutomationPreFilter = function (key, filter) {
                    this.addAutomationFilter(this._preFilters, key, "IAutomationPreFilter", filter);
                };
                Automation.prototype.removeAutomationPreFilter = function (key) {
                    this.removeAutomationFilter(this._preFilters, key, "IAutomationPreFilter");
                };
                Automation.prototype.addAutomationAlertBypassFilter = function (key, filter) {
                    this.addAutomationFilter(this._alertFilters, key, "IAutomationAlertBypassFilter", filter);
                };
                Automation.prototype.removeIAutomationAlertBypassFilter = function (key) {
                    this.removeAutomationFilter(this._alertFilters, key, "IAutomationAlertBypassFilter");
                };
                Automation.prototype.addAutomationConfirmationBypassFilter = function (key, filter) {
                    this.addAutomationFilter(this._confirmationFilters, key, "IAutomationConfirmationBypassFilter", filter);
                };
                Automation.prototype.removeAutomationConfirmationBypassFilter = function (key) {
                    this.removeAutomationFilter(this._confirmationFilters, key, "IAutomationConfirmationBypassFilter");
                };
                Automation.prototype.getPreFilterPromise = function (preFilter, args) {
                    if (preFilter) {
                        return preFilter.onFilter(args);
                    }
                    throw "Pre-filter is null or undefined";
                };
                Automation.prototype.removeAutomationFilter = function (filterStore, key, automationFilterType) {
                    if (!key) {
                        throw new Error("key is null, undefined or evaluates to false");
                    }
                    if (!filterStore) {
                        throw new Error("key is null, undefined or evaluates to false");
                    }
                    if (!automationFilterType) {
                        throw new Error("automationFilterType is null, undefined or evaluates to false");
                    }
                    delete filterStore[key];
                    this._logger.debug(automationFilterType + " with key '" + key + "' has been removed");
                };
                Automation.prototype.addAutomationFilter = function (filterStore, key, automationFilterType, filter) {
                    if (!filterStore) {
                        throw new Error("Invalid filterStore");
                    }
                    if (!filter) {
                        throw new Error("Invalid filter");
                    }
                    if (!key) {
                        throw new Error("Invalid automation key");
                    }
                    if (!automationFilterType) {
                        throw new Error("Invalid automation filter type");
                    }
                    if (filterStore[key]) {
                        this._logger.debug("Replacing existing " + automationFilterType + " with key '" + key + "'");
                    }
                    filterStore[key] = filter;
                    this._logger.debug(automationFilterType + " with key '" + key + "' has been added");
                };
                Automation.prototype.getPostFilterPromise = function (filter, promiseFunc, oncancel, args) {
                    var _this = this;
                    return new Microsoft.Plugin.Promise(function (complete, err, prog) {
                        var filterComplete = function (value) {
                            return filter.onComplete(value, args).then(function () {
                                complete(value);
                            }, function () {
                                _this._logger.error("Error occured during execution of post-filter onComplete handler");
                            });
                        };
                        var filterError = function (value) {
                            return filter.onError(value, args).then(function () {
                                err(value);
                            }, function () {
                                _this._logger.error("Error occured during execution of post-filter onError handler");
                            });
                        };
                        var filterProgress = function (value) {
                            return filter.onProgress(value, args).then(function () {
                                prog(value);
                            }, function () {
                                _this._logger.error("Error occured during execution of post-filter onProgess handler");
                            });
                        };
                        promiseFunc(filterComplete, filterError, filterProgress, args);
                    }, oncancel);
                };
                return Automation;
            }());
            var AutomationConstants = (function () {
                function AutomationConstants() {
                }
                AutomationConstants.SearchNoResultsAlertKey = "Microsoft.VisualStudio.DiagnosticsHub.CpuUsageTreeGrid.Search";
                AutomationConstants.SearchNoResultsConfirmationKey = "Microsoft.VisualStudio.DiagnosticsHub.CpuUsageTreeGrid.Search";
                AutomationConstants.DataWarehouseRequestKey = "Microsoft.VisualStudio.DiagnosticsHub.DatawarehouseRequest";
                return AutomationConstants;
            }());
            DiagnosticsHub.AutomationConstants = AutomationConstants;
            var automationManager = null;
            function getAutomationManager(logger) {
                if (automationManager === null) {
                    automationManager = new Automation(logger);
                }
                return automationManager;
            }
            DiagnosticsHub.getAutomationManager = getAutomationManager;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var BigNumber = (function () {
                function BigNumber(high, low) {
                    this._isHighNegative = false;
                    this._isLowNegative = false;
                    if (!(typeof high === "number" && high < 0x100000000 && high >= -1 * 0x80000000) ||
                        !(typeof low === "number" && low < 0x100000000 && low >= -1 * 0x80000000)) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1000"));
                    }
                    if (high < 0) {
                        high = (high >>> 0);
                        this._isHighNegative = true;
                    }
                    if (low < 0) {
                        low = (low >>> 0);
                        this._isLowNegative = true;
                    }
                    this._value = {
                        h: high,
                        l: low
                    };
                }
                Object.defineProperty(BigNumber, "oldest", {
                    get: function () {
                        return BigNumber.OldestTimestampFormat;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(BigNumber, "latest", {
                    get: function () {
                        return BigNumber.LatestTimestampFormat;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(BigNumber, "zero", {
                    get: function () {
                        if (!BigNumber.Zero) {
                            BigNumber.Zero = new BigNumber(0, 0);
                        }
                        return BigNumber.Zero;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(BigNumber, "one", {
                    get: function () {
                        if (!BigNumber.One) {
                            BigNumber.One = new BigNumber(0, 1);
                        }
                        return BigNumber.One;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(BigNumber.prototype, "jsonValue", {
                    get: function () {
                        if (!this._jsonValue) {
                            var high = this._value.h;
                            if (this._isHighNegative || high > 0x7fffffff) {
                                high = high << 0;
                            }
                            var low = this._value.l;
                            if (this._isLowNegative || low > 0x7fffffff) {
                                low = low << 0;
                            }
                            this._jsonValue = {
                                h: high,
                                l: low
                            };
                        }
                        return this._jsonValue;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(BigNumber.prototype, "value", {
                    get: function () {
                        if (!this._stringValue) {
                            if (this._value.h > 0) {
                                this._stringValue = "0x" +
                                    this._value.h.toString(16) +
                                    BigNumber.padLeadingZeros(this._value.l.toString(16), 8);
                            }
                            else {
                                this._stringValue = "0x" + this._value.l.toString(16);
                            }
                        }
                        return this._stringValue;
                    },
                    enumerable: true,
                    configurable: true
                });
                BigNumber.max = function (first, second) {
                    return first.greaterOrEqual(second) ? first : second;
                };
                BigNumber.min = function (first, second) {
                    return first.greaterOrEqual(second) ? second : first;
                };
                BigNumber.add = function (first, second) {
                    return BigNumber.addition(first, second);
                };
                BigNumber.subtract = function (first, second) {
                    if (second.greater(first)) {
                        return BigNumber.zero;
                    }
                    var otherTime = BigNumber.convertToManagedTimeFormat(second.jsonValue);
                    var negateHigh = ~(otherTime.h);
                    var negateLow = ~(otherTime.l);
                    var twosComplement = BigNumber.addition(new BigNumber(negateHigh, negateLow), BigNumber.one, true);
                    return BigNumber.addition(first, twosComplement, true);
                };
                BigNumber.multiply = function (first, second) {
                    return BigNumber.multiplication(first, second);
                };
                BigNumber.divide = function (first, second) {
                    return BigNumber.division(first, second, false);
                };
                BigNumber.modulo = function (first, second) {
                    return BigNumber.division(first, second, true);
                };
                BigNumber.addNumber = function (first, second) {
                    if (second < 0) {
                        return BigNumber.subtract(first, BigNumber.convertFromNumber(-second));
                    }
                    else {
                        return BigNumber.addition(first, BigNumber.convertFromNumber(second));
                    }
                };
                BigNumber.subtractNumber = function (first, second) {
                    if (second < 0) {
                        return BigNumber.addition(first, BigNumber.convertFromNumber(-second));
                    }
                    else {
                        return BigNumber.subtract(first, BigNumber.convertFromNumber(second));
                    }
                };
                BigNumber.multiplyNumber = function (first, second) {
                    if (second < 0) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1000"));
                    }
                    return BigNumber.multiply(first, BigNumber.convertFromNumber(second));
                };
                BigNumber.divideNumber = function (first, second) {
                    if (second < 0) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1000"));
                    }
                    return BigNumber.divide(first, BigNumber.convertFromNumber(second));
                };
                BigNumber.moduloNumber = function (first, second) {
                    if (second < 0) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1000"));
                    }
                    return BigNumber.modulo(first, BigNumber.convertFromNumber(second));
                };
                BigNumber.convertFromNumber = function (num) {
                    if ((num < 0) || !(num < 0x20000000000000)) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1000"));
                    }
                    num = Math.floor(num);
                    var low = num & 0xFFFFFFFF;
                    if (num <= 0xFFFFFFFF) {
                        return new BigNumber(0, low);
                    }
                    var highStr = num.toString(16);
                    highStr = highStr.substring(0, highStr.length - 8);
                    var high = parseInt(highStr, 16);
                    return new BigNumber(high, low);
                };
                BigNumber.convertFromBinaryString = function (bits) {
                    if (!bits || bits.match("[^10]") || bits.length > 64) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1000" + " " + bits));
                    }
                    var high = 0;
                    var low = 0;
                    if (bits.length <= 32) {
                        low = parseInt(bits, 2);
                    }
                    else {
                        low = parseInt(bits.slice(bits.length - 32), 2);
                        high = parseInt(bits.slice(0, bits.length - 32), 2);
                    }
                    return new BigNumber(high, low);
                };
                BigNumber.getBinaryString = function (timestamp) {
                    var lowPart = timestamp._value.l.toString(2);
                    if (timestamp._value.h > 0) {
                        return timestamp._value.h.toString(2) + Microsoft.VisualStudio.DiagnosticsHub.BigNumber.padLeadingZeros(lowPart, 32);
                    }
                    else {
                        return lowPart;
                    }
                };
                BigNumber.padLeadingZeros = function (value, totalLength) {
                    var padded = value;
                    var zeros = "00000000";
                    if (padded && totalLength && totalLength > 0) {
                        while (totalLength - padded.length >= 8) {
                            padded = zeros + padded;
                        }
                        padded = zeros.substr(0, totalLength - padded.length) + padded;
                    }
                    return padded;
                };
                BigNumber.prototype.equals = function (other) {
                    var isEqual = false;
                    var otherTime = BigNumber.convertToManagedTimeFormat(other.jsonValue);
                    isEqual = (this._value.h === otherTime.h && this._value.l === otherTime.l);
                    return isEqual;
                };
                BigNumber.prototype.greater = function (other) {
                    var isGreater = false;
                    var otherTime = BigNumber.convertToManagedTimeFormat(other.jsonValue);
                    if (this._value.h > otherTime.h) {
                        isGreater = true;
                    }
                    else if (this._value.h === otherTime.h) {
                        if (this._value.l > otherTime.l) {
                            isGreater = true;
                        }
                    }
                    return isGreater;
                };
                BigNumber.prototype.greaterOrEqual = function (other) {
                    var isGreaterOrEqual = false;
                    var otherTime = BigNumber.convertToManagedTimeFormat(other.jsonValue);
                    if (this._value.h > otherTime.h) {
                        isGreaterOrEqual = true;
                    }
                    else if (this._value.h === otherTime.h) {
                        if (this._value.l >= otherTime.l) {
                            isGreaterOrEqual = true;
                        }
                    }
                    return isGreaterOrEqual;
                };
                BigNumber.prototype.compareTo = function (other) {
                    if (this.greater(other)) {
                        return 1;
                    }
                    else if (this.equals(other)) {
                        return 0;
                    }
                    else {
                        return -1;
                    }
                };
                BigNumber.convertToManagedTimeFormat = function (time) {
                    var high = time.h < 0 ? time.h >>> 0 : time.h;
                    var low = time.l < 0 ? time.l >>> 0 : time.l;
                    return {
                        h: high,
                        l: low
                    };
                };
                BigNumber.addition = function (first, second, ignoreOverflow) {
                    if (ignoreOverflow === void 0) { ignoreOverflow = false; }
                    var firstTime = BigNumber.convertToManagedTimeFormat(first.jsonValue);
                    var secondTime = BigNumber.convertToManagedTimeFormat(second.jsonValue);
                    var low = 0;
                    var high = 0;
                    var low0 = (firstTime.l & 0xff) + (secondTime.l & 0xff);
                    var low8 = (low0 >>> 8) + ((firstTime.l >>> 8) & 0xff) + ((secondTime.l >>> 8) & 0xff);
                    low0 = low0 & 0xff;
                    var low16 = (low8 >>> 8) + ((firstTime.l >>> 16) & 0xff) + ((secondTime.l >>> 16) & 0xff);
                    low8 = low8 & 0xff;
                    var low24 = (low16 >>> 8) + ((firstTime.l >>> 24) & 0xff) + ((secondTime.l >>> 24) & 0xff);
                    low16 = low16 & 0xff;
                    var high0 = (low24 >>> 8) + (firstTime.h & 0xff) + (secondTime.h & 0xff);
                    low24 = low24 & 0xff;
                    var high8 = (high0 >>> 8) + ((firstTime.h >>> 8) & 0xff) + ((secondTime.h >>> 8) & 0xff);
                    high0 = high0 & 0xff;
                    var high16 = (high8 >>> 8) + ((firstTime.h >>> 16) & 0xff) + ((secondTime.h >>> 16) & 0xff);
                    high8 = high8 & 0xff;
                    var high24 = (high16 >>> 8) + ((firstTime.h >>> 24) & 0xff) + ((secondTime.h >>> 24) & 0xff);
                    high16 = high16 & 0xff;
                    if (!ignoreOverflow && (high24 >>> 8) > 0) {
                        Microsoft.VisualStudio.DiagnosticsHub.getLogger().error("Addition overflow. Lost upper bits from: 0x" + high24.toString(16));
                        return new BigNumber(0xffffffff, 0xffffffff);
                    }
                    high24 = high24 & 0xff;
                    var finalLow16 = low24 << 8 | low16;
                    var finalLow0 = low8 << 8 | low0;
                    var finalHigh16 = high24 << 8 | high16;
                    var finalHigh0 = high8 << 8 | high0;
                    low = (finalLow16 << 16) | finalLow0;
                    high = (finalHigh16 << 16) | finalHigh0;
                    return new BigNumber(high, low);
                };
                BigNumber.multiplication = function (first, second) {
                    var firstTime = BigNumber.convertToManagedTimeFormat(first.jsonValue);
                    var secondTime = BigNumber.convertToManagedTimeFormat(second.jsonValue);
                    if (firstTime.h === 0 && secondTime.h === 0 &&
                        0 < firstTime.l && firstTime.l <= 0x4000000 &&
                        0 < secondTime.l && secondTime.l <= 0x4000000) {
                        var product = firstTime.l * secondTime.l;
                        return BigNumber.convertFromNumber(product);
                    }
                    var a1 = firstTime.l & 0xFFFF;
                    var a2 = firstTime.l >>> 0x10;
                    var a3 = firstTime.h & 0xFFFF;
                    var a4 = firstTime.h >>> 0x10;
                    var b1 = secondTime.l & 0xFFFF;
                    var b2 = secondTime.l >>> 0x10;
                    var b3 = secondTime.h & 0xFFFF;
                    var b4 = secondTime.h >>> 0x10;
                    var c1 = a1 * b1;
                    var c2 = c1 >>> 0x10;
                    c1 &= 0xFFFF;
                    c2 += a2 * b1;
                    var c3 = c2 >>> 0x10;
                    c2 &= 0xFFFF;
                    c2 += a1 * b2;
                    c3 += c2 >>> 0x10;
                    c2 &= 0xFFFF;
                    c3 += a3 * b1;
                    var c4 = c3 >>> 0x10;
                    c3 &= 0xFFFF;
                    c3 += a2 * b2;
                    c4 += c3 >>> 0x10;
                    c3 &= 0xFFFF;
                    c3 += a1 * b3;
                    c4 += c3 >>> 0x10;
                    c3 &= 0xFFFF;
                    c4 += a4 * b1 + a3 * b2 + a2 * b3 + a1 * b4;
                    if (c4 > 0xFFFF) {
                        Microsoft.VisualStudio.DiagnosticsHub.getLogger().error("Multiplication overflow. Lost upper 16-bits from: 0x" + c4.toString(16));
                    }
                    c4 &= 0xFFFF;
                    var productHigh = (c4 << 0x10) | c3;
                    var productLow = (c2 << 0x10) | c1;
                    return new BigNumber(productHigh, productLow);
                };
                BigNumber.division = function (dividend, divisor, wantRemainder) {
                    if (divisor.greater(dividend)) {
                        return wantRemainder ? dividend : BigNumber.zero;
                    }
                    if (divisor.equals(BigNumber.zero)) {
                        if (wantRemainder) {
                            return dividend;
                        }
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1000"));
                    }
                    var dividendBits = BigNumber.getBinaryString(dividend);
                    var divisorBits = BigNumber.getBinaryString(divisor);
                    var divisorLength = divisorBits.length;
                    var dividendLength = dividendBits.length;
                    var timeStamp2toThe53 = new BigNumber(0x200000, 0);
                    if (timeStamp2toThe53.greater(dividend)) {
                        var dividendNum = parseInt(dividend.value);
                        var divisorNum = parseInt(divisor.value);
                        return wantRemainder ? BigNumber.convertFromNumber(dividendNum % divisorNum) : BigNumber.convertFromNumber(dividendNum / divisorNum);
                    }
                    var quotientString = "";
                    var nextIndex = divisorLength;
                    var currDividend = BigNumber.convertFromBinaryString(dividendBits.substr(0, divisorLength));
                    while (nextIndex <= dividendLength) {
                        if (currDividend.greater(divisor) || currDividend.equals(divisor)) {
                            quotientString += "1";
                            currDividend = BigNumber.subtract(currDividend, divisor);
                        }
                        else {
                            quotientString += "0";
                        }
                        if (nextIndex !== dividendLength) {
                            currDividend = BigNumber.convertFromBinaryString(BigNumber.getBinaryString(currDividend) + dividendBits[nextIndex]);
                        }
                        nextIndex++;
                    }
                    return wantRemainder ? currDividend : BigNumber.convertFromBinaryString(quotientString);
                };
                BigNumber.OldestTimestampFormat = {
                    h: 0,
                    l: 0
                };
                BigNumber.LatestTimestampFormat = {
                    h: 0xffffffff,
                    l: 0xffffffff
                };
                return BigNumber;
            }());
            DiagnosticsHub.BigNumber = BigNumber;
            var JsonTimespan = (function () {
                function JsonTimespan(begin, end) {
                    if (begin.greater(end)) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1000"));
                    }
                    this._begin = begin;
                    this._end = end;
                }
                Object.defineProperty(JsonTimespan.prototype, "begin", {
                    get: function () {
                        return this._begin;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(JsonTimespan.prototype, "end", {
                    get: function () {
                        return this._end;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(JsonTimespan.prototype, "elapsed", {
                    get: function () {
                        if (!this._elapsed) {
                            this._elapsed = BigNumber.subtract(this.end, this.begin);
                        }
                        return this._elapsed;
                    },
                    enumerable: true,
                    configurable: true
                });
                JsonTimespan.prototype.equals = function (other) {
                    return this.begin.equals(other.begin) && this.end.equals(other.end);
                };
                JsonTimespan.prototype.contains = function (time) {
                    return time.greaterOrEqual(this.begin) && this.end.greaterOrEqual(time);
                };
                return JsonTimespan;
            }());
            DiagnosticsHub.JsonTimespan = JsonTimespan;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var DataWarehouse;
            (function (DataWarehouse) {
                "use strict";
                var DhContextData = (function () {
                    function DhContextData() {
                    }
                    return DhContextData;
                }());
                DataWarehouse.DhContextData = DhContextData;
            })(DataWarehouse = DiagnosticsHub.DataWarehouse || (DiagnosticsHub.DataWarehouse = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var Logger = (function () {
                function Logger() {
                    var _this = this;
                    this._isInfoOn = true;
                    this._isDebugOn = true;
                    this._isWarningOn = true;
                    this._isErrorOn = true;
                    this._loggerProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.LoggerPortMarshaler", {}, true);
                    this._loggerProxy._call("isInfoOn").done(function (infoOn) {
                        _this._isInfoOn = infoOn;
                    });
                    this._loggerProxy._call("isDebugOn").done(function (debugOn) {
                        _this._isDebugOn = debugOn;
                    });
                    this._loggerProxy._call("isWarningOn").done(function (warningOn) {
                        _this._isWarningOn = warningOn;
                    });
                    this._loggerProxy._call("isErrorOn").done(function (errorOn) {
                        _this._isErrorOn = errorOn;
                    });
                    try {
                        var apex = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.Test.Apex.DiagnosticsHub.ApexJSExtension", {}, true);
                        if (apex !== null) {
                            apex._call("getApexJavaScript").done(function (result) {
                                if (result) {
                                    _this.debug("got apex javascript files");
                                    var scriptObj = document.createElement("script");
                                    scriptObj.setAttribute("type", "text/javascript");
                                    scriptObj.setAttribute("src", result);
                                    var head = document.getElementsByTagName("head");
                                    if (!head) {
                                        _this.debug("Unable to add apex script to document");
                                    }
                                    else {
                                        head[0].appendChild(scriptObj);
                                        _this.debug("Added ApexJSExtension '" + result + "' to document");
                                    }
                                }
                                else {
                                    _this.debug("no file was returned by getApexJavaScript, cannot inject TestExtension.ts for ApexJS framework");
                                }
                            }, function (error) {
                                _this.debug("Error when calling getApexJavaScript function:" + String(error));
                            });
                        }
                        else {
                            this.debug("Unable to connect to port marshaler 'Microsoft.Test.Apex.DiagnosticsHub.ApexJSExtension'");
                        }
                    }
                    catch (e) {
                        this.error(e.toString());
                    }
                }
                Logger.prototype.info = function (message) {
                    if (this._isInfoOn) {
                        this._loggerProxy._call("logInfo", message);
                    }
                };
                Logger.prototype.debug = function (message) {
                    if (this._isDebugOn) {
                        this._loggerProxy._call("logDebug", message);
                    }
                };
                Logger.prototype.warning = function (message) {
                    if (this._isWarningOn) {
                        this._loggerProxy._call("logWarning", message);
                    }
                };
                Logger.prototype.error = function (message) {
                    if (this._isErrorOn) {
                        this._loggerProxy._call("logError", message);
                    }
                };
                return Logger;
            }());
            var _logger = null;
            function getLogger() {
                if (_logger === null) {
                    _logger = new Logger();
                }
                return _logger;
            }
            DiagnosticsHub.getLogger = getLogger;
            Microsoft.Plugin.addEventListener("pluginready", function () {
                getLogger();
            });
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            function InitializeErrorReporting() {
                window.onerror = function (message, filename, lineno, colno, error) {
                    var logger = DiagnosticsHub.getLogger();
                    var errorMessage = "Script error caught in: " + (filename || "unknown script file") + " at " + lineno + "\n" + message;
                    logger.error(errorMessage);
                    Microsoft.VisualStudio.DiagnosticsHub.Debug.Assert.fail(errorMessage);
                    Microsoft.Plugin.Diagnostics.reportError(message, filename, lineno, message, colno);
                    Microsoft.Plugin.Diagnostics.terminate();
                };
            }
            DiagnosticsHub.InitializeErrorReporting = InitializeErrorReporting;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            function eventThrottler(callback, timeout) {
                var shouldDrop = false;
                var droppedEvent = false;
                var latestArgs = null;
                var throttle = function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i - 0] = arguments[_i];
                    }
                    latestArgs = args;
                    if (!shouldDrop) {
                        callback.apply(null, args);
                        shouldDrop = true;
                        window.setTimeout(function () {
                            shouldDrop = false;
                            if (droppedEvent) {
                                window.setTimeout(throttle, 0, latestArgs);
                            }
                            droppedEvent = false;
                        }, timeout);
                    }
                    else {
                        droppedEvent = true;
                    }
                };
                return throttle;
            }
            DiagnosticsHub.eventThrottler = eventThrottler;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var EventDeferral = (function () {
                function EventDeferral(onHandlerCompleted) {
                    this._onHandlerCompleted = onHandlerCompleted;
                }
                EventDeferral.prototype.complete = function () {
                    this._onHandlerCompleted();
                };
                return EventDeferral;
            }());
            var StateChangedEventArgs = (function () {
                function StateChangedEventArgs(eventArgs, onHandlerCompleted) {
                    this._eventArgs = eventArgs;
                    this._waitHandler = false;
                    this._onHandlerCompleted = onHandlerCompleted;
                    this._eventDeferral = null;
                }
                Object.defineProperty(StateChangedEventArgs.prototype, "currentState", {
                    get: function () {
                        return this._eventArgs.CurrentState;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(StateChangedEventArgs.prototype, "previousState", {
                    get: function () {
                        return this._eventArgs.PreviousState;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(StateChangedEventArgs.prototype, "waitHandler", {
                    get: function () {
                        return this._eventDeferral !== null;
                    },
                    enumerable: true,
                    configurable: true
                });
                StateChangedEventArgs.prototype.getDeferral = function () {
                    if (this._eventDeferral === null) {
                        this._eventDeferral = new EventDeferral(this._onHandlerCompleted);
                    }
                    return this._eventDeferral;
                };
                return StateChangedEventArgs;
            }());
            var Session = (function () {
                function Session(logger) {
                    var _this = this;
                    this._eventsListeners = new Array();
                    this._logger = logger;
                    this._isInitialized = false;
                    this._sessionProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.SessionPortMarshaler", {}, true);
                    this._initializationPromise = this._sessionProxy._call("initialize");
                    this._initializationPromise.done(function () {
                        _this._logger.debug("JavaScript session object connected to host. Ready to get session state notification events.");
                        _this._isInitialized = true;
                    }, function (error) {
                        _this._logger.error("Cannot initialize session, error name: '" + error.name + "', error message: '" + error.message + "'");
                    });
                    this._sessionProxy.addEventListener("sessionStateChanged", this.stateChangedHandler.bind(this));
                }
                Session.prototype.stopCollection = function () {
                    return this._sessionProxy._call("stopCollection");
                };
                Session.prototype.canStopCollection = function () {
                    return this._sessionProxy._call("canStopCollection");
                };
                Session.prototype.getPerformanceDebuggerSessionTargetProcessInformation = function () {
                    return this._sessionProxy._call("getPerformanceDebuggerSessionTargetProcessInformation");
                };
                Session.prototype.getState = function () {
                    return this._sessionProxy._call("getState");
                };
                Session.prototype.addStateChangedEventListener = function (listener) {
                    this._eventsListeners.push(listener);
                    this._logger.debug("State changed event handler added.");
                };
                Session.prototype.isInitialized = function () {
                    return this._isInitialized;
                };
                Session.prototype.removeStateChangedEventListener = function (listener) {
                    for (var i = 0; i < this._eventsListeners.length; i++) {
                        if (this._eventsListeners[i] === listener) {
                            this._logger.debug("State changed event handler removed.");
                            this._eventsListeners.splice(i, 1);
                            break;
                        }
                    }
                };
                Session.prototype.stateChangedHandler = function (eventArgs) {
                    var _this = this;
                    this._logger.debug("Invoking JavaScript handlers for State Change Event.");
                    var handlersCount = 0;
                    var onCompleted = function () {
                        handlersCount--;
                        if (handlersCount <= 0) {
                            _this._sessionProxy._call("sessionStateChangedCompleted", eventArgs.Token);
                        }
                        else {
                            _this._logger.debug("Still waiting when all event state change handlers will complete their work. Handlers count: " + handlersCount);
                        }
                    };
                    for (var propertyName in this._eventsListeners) {
                        var handler = this._eventsListeners[propertyName];
                        if (this._eventsListeners.hasOwnProperty(propertyName)) {
                            if (typeof handler === "function") {
                                try {
                                    var jsEventArgs = new StateChangedEventArgs(eventArgs, onCompleted);
                                    handler(jsEventArgs);
                                    if (jsEventArgs.waitHandler) {
                                        handlersCount++;
                                        this._logger.debug("JavaScipt handlers for event state changed asked to wait while they will finish. Handlers count: " + handlersCount);
                                    }
                                }
                                catch (e) {
                                    this._logger.error(e.toString());
                                }
                            }
                            else {
                                this._logger.warning("One of the listeners not a 'function', it has type " + (typeof handler));
                            }
                        }
                    }
                    if (handlersCount === 0) {
                        onCompleted();
                    }
                };
                return Session;
            }());
            var _currentSession = null;
            function getCurrentSession() {
                if (_currentSession === null) {
                    _currentSession = new Session(DiagnosticsHub.getLogger());
                }
                return _currentSession;
            }
            DiagnosticsHub.getCurrentSession = getCurrentSession;
            Microsoft.Plugin.addEventListener("pluginready", function () {
                getCurrentSession();
            });
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var DataWarehouse;
            (function (DataWarehouse) {
                "use strict";
                var DataWarehouseService = (function () {
                    function DataWarehouseService() {
                        this._serviceProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.DataWarehouseServiceMarshaler", {}, true);
                        this._logger = DiagnosticsHub.getLogger();
                    }
                    DataWarehouseService.prototype.getAllDataSourceInfos = function (callback) {
                        var _this = this;
                        this._serviceProxy._call("getAllDataSourceInfos")
                            .done(function (result) {
                            var infos = [];
                            for (var i = 0; i < result.length; i++) {
                                var dataSource = result[i];
                                if (dataSource.type === 1 ||
                                    dataSource.type === 2 ||
                                    dataSource.type === 4) {
                                    infos.push(dataSource);
                                }
                                else {
                                    _this._logger.error("Unknown data source info type: " + dataSource.type);
                                }
                            }
                            callback(infos);
                        });
                    };
                    return DataWarehouseService;
                }());
                var _service = null;
                function getDataWarehouseService() {
                    if (_service === null) {
                        _service = new DataWarehouseService();
                    }
                    return _service;
                }
                DataWarehouse.getDataWarehouseService = getDataWarehouseService;
                Microsoft.Plugin.addEventListener("pluginready", function () {
                    getDataWarehouseService();
                });
            })(DataWarehouse = DiagnosticsHub.DataWarehouse || (DiagnosticsHub.DataWarehouse = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var Publisher = (function () {
                function Publisher(events) {
                    if (events === void 0) { events = null; }
                    this._events = {};
                    this._listeners = {};
                    if (events && events.length > 0) {
                        for (var i = 0; i < events.length; i++) {
                            var type = events[i];
                            if (type) {
                                this._events[type] = type;
                            }
                        }
                    }
                    else {
                        this._events = null;
                    }
                }
                Publisher.prototype.dispose = function () {
                    delete this._events;
                    delete this._listeners;
                };
                Publisher.prototype.addEventListener = function (eventType, func) {
                    if (eventType && func) {
                        if (this._events === null || this._events[eventType]) {
                            if (!this._listeners[eventType]) {
                                this._listeners[eventType] = [];
                            }
                            this._listeners[eventType].push(func);
                        }
                    }
                };
                Publisher.prototype.removeEventListener = function (eventType, func) {
                    if (eventType && func) {
                        if (this._events === null || this._events[eventType]) {
                            var callbacks = this._listeners[eventType];
                            if (callbacks) {
                                for (var i = 0; i < callbacks.length; i++) {
                                    if (func === callbacks[i]) {
                                        callbacks.splice(i, 1);
                                        break;
                                    }
                                }
                                if (callbacks.length === 0) {
                                    delete this._listeners[eventType];
                                }
                            }
                        }
                    }
                };
                Publisher.prototype.invokeListener = function (eventType, args) {
                    if (eventType) {
                        if (this._events === null || this._events[eventType]) {
                            var callbacks = this._listeners[eventType];
                            if (callbacks) {
                                for (var i = 0; i < callbacks.length; i++) {
                                    var func = callbacks[i];
                                    if (func) {
                                        func(args);
                                    }
                                }
                            }
                        }
                    }
                };
                return Publisher;
            }());
            DiagnosticsHub.Publisher = Publisher;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var EventAggregator = (function () {
                function EventAggregator(logger) {
                    var _this = this;
                    this._eventsListeners = {};
                    this._publisher = new DiagnosticsHub.Publisher();
                    this._logger = logger;
                    this._eventAggregatorProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.EventAggregatorMarshaler", {}, true);
                    this._eventAggregatorProxy.addEventListener("globalEventHandler", function (eventArgs) {
                        _this.globalEventHandler(eventArgs);
                    });
                }
                EventAggregator.prototype.addEventListener = function (eventType, listener) {
                    this._publisher.addEventListener(eventType, listener);
                    this._logger.debug("EventAggregator:: Event listener added for event type '" + eventType + "'");
                };
                EventAggregator.prototype.removeEventListener = function (eventType, listener) {
                    this._publisher.removeEventListener(eventType, listener);
                    this._logger.debug("EventAggregator:: Event listener removed for event type '" + eventType + "'");
                };
                EventAggregator.prototype.globalEventHandler = function (eventArgs) {
                    var eventType = eventArgs.EventType;
                    this._logger.debug("EventAggregator:: Handling event type " + eventType + ".");
                    var dataString = eventArgs.Data.Json;
                    this._logger.debug("EventAggregator:: Raise handler for event type " + eventType + " with data " + dataString + ".");
                    try {
                        var data = null;
                        if (dataString !== null && typeof dataString === "string" && dataString !== "") {
                            data = JSON.parse(dataString);
                        }
                        this._publisher.invokeListener(eventType, data);
                    }
                    catch (e) {
                        this._logger.error(e.toString());
                    }
                };
                EventAggregator.prototype.raiseEvent = function (eventType, data) {
                    var dataString = null;
                    if (data !== null && typeof data !== "undefined") {
                        dataString = JSON.stringify(data);
                    }
                    this._logger.debug("EventAggregator:: Raising event type " + eventType + " with data " + dataString + ".");
                    this._eventAggregatorProxy._call("raiseEvent", eventType, dataString);
                };
                return EventAggregator;
            }());
            var LocalEventAggregator = (function () {
                function LocalEventAggregator() {
                    this._publisher = new DiagnosticsHub.Publisher();
                }
                LocalEventAggregator.prototype.addEventListener = function (eventType, listener) {
                    this._publisher.addEventListener(eventType, listener);
                };
                LocalEventAggregator.prototype.removeEventListener = function (eventType, listener) {
                    this._publisher.removeEventListener(eventType, listener);
                };
                LocalEventAggregator.prototype.raiseEvent = function (eventType, data) {
                    this._publisher.invokeListener(eventType, data);
                };
                return LocalEventAggregator;
            }());
            DiagnosticsHub.LocalEventAggregator = LocalEventAggregator;
            var _eventAggregator = null;
            function getEventAggregator() {
                if (_eventAggregator === null) {
                    if (Microsoft.Plugin.F12) {
                        _eventAggregator = new LocalEventAggregator();
                    }
                    else {
                        _eventAggregator = new EventAggregator(DiagnosticsHub.getLogger());
                    }
                }
                return _eventAggregator;
            }
            DiagnosticsHub.getEventAggregator = getEventAggregator;
            Microsoft.Plugin.addEventListener("pluginready", function () {
                getEventAggregator();
            });
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var serviceHub;
            var DataWarehouseServiceHubHost = (function () {
                function DataWarehouseServiceHubHost() {
                    this._logger = DiagnosticsHub.getLogger();
                    this._controllers = {};
                    this._requestId = 1;
                    this._requestProgressCallbacks = {};
                    if (!serviceHub) {
                        serviceHub = require("serviceHub");
                    }
                    this._automationManager = DiagnosticsHub.getAutomationManager(this._logger);
                    this._serviceHubClient = new serviceHub.HubClient("diagnostics-hub");
                }
                DataWarehouseServiceHubHost.prototype.request = function (controllerId, actionId, sessionId, request) {
                    request = request || {};
                    request.sessionId = sessionId;
                    var controller = this.getController(controllerId);
                    var taskToken;
                    var requestPromiseFunc = function (completed, error, progress) {
                        var makeRequest = function (actionId, requestData) {
                            controller.request(actionId, requestData)
                                .then(function (response) {
                                if (response.type === DataWarehouseServiceHubHost.DATAWAREHOUSE_HOST_RESPONSE_TYPE_SUCCESS) {
                                    completed(JSON.parse(response.content));
                                }
                                else if (response.type === DataWarehouseServiceHubHost.DATAWAREHOUSE_HOST_RESPONSE_TYPE_PENDING) {
                                    if (actionId !== DiagnosticsHub.DataWarehouse.Constants.ACTION_DATAWAREHOUSE_GETSTATUS) {
                                        taskToken = response.content;
                                    }
                                    else if (progress) {
                                        progress(JSON.parse(response.content));
                                    }
                                    makeRequest(DiagnosticsHub.DataWarehouse.Constants.ACTION_DATAWAREHOUSE_GETSTATUS, taskToken);
                                }
                                else if (response.type === DataWarehouseServiceHubHost.DATAWAREHOUSE_HOST_RESPONSE_TYPE_CANCELED) {
                                    if (error) {
                                        error(new Error("Canceled"));
                                    }
                                }
                                else if (response.type === DataWarehouseServiceHubHost.DATAWAREHOUSE_HOST_RESPONSE_TYPE_FAILURE) {
                                    var newError = new Error(response.content);
                                    if (error) {
                                        error(newError);
                                    }
                                    else {
                                        throw newError;
                                    }
                                }
                                else {
                                    throw new Error("Invalid response from DataWarehouse");
                                }
                            });
                        };
                        makeRequest(actionId, JSON.stringify(request));
                    };
                    var requestPromiseCancelFunc = function () {
                        if (taskToken) {
                            controller.request(DiagnosticsHub.DataWarehouse.Constants.ACTION_DATAWAREHOUSE_CANCELTASK, taskToken);
                        }
                    };
                    var requestEnvelope = {
                        controllerId: controllerId,
                        actionId: actionId,
                        sessionId: sessionId,
                        request: request
                    };
                    var requestPromise = this._automationManager.getAutomationPromise(DiagnosticsHub.AutomationConstants.DataWarehouseRequestKey, requestPromiseFunc, requestPromiseCancelFunc, requestEnvelope);
                    return requestPromise;
                };
                DataWarehouseServiceHubHost.prototype.requestSync = function (controllerId, actionId, sessionId, request) {
                    throw new Error("Not Implemented.");
                };
                DataWarehouseServiceHubHost.prototype.initialize = function () {
                    var _this = this;
                    var initializeControllersPromises = [];
                    initializeControllersPromises.push(this._serviceHubClient.getSessionId()
                        .then(function (id) {
                        _this._hostSessionId = id;
                    }));
                    initializeControllersPromises.push(DiagnosticsHub.DataWarehouseController.create(this._serviceHubClient)
                        .then(function (controller) {
                        _this._controllers[DiagnosticsHub.DataWarehouse.Constants.CONTROLLER_ID_DATAWAREHOUSE] = controller;
                    }));
                    initializeControllersPromises.push(DiagnosticsHub.ContextServiceController.create(this._serviceHubClient)
                        .then(function (controller) {
                        _this._controllers[DiagnosticsHub.DataWarehouse.Constants.CONTROLLER_ID_DATAWAREHOUSECONTEXTSERVICE] = controller;
                    }));
                    initializeControllersPromises.push(DiagnosticsHub.ContextController.create(this._serviceHubClient)
                        .then(function (controller) {
                        _this._controllers[DiagnosticsHub.DataWarehouse.Constants.CONTROLLER_ID_DATAWAREHOUSECONTEXT] = controller;
                    }));
                    initializeControllersPromises.push(DiagnosticsHub.JmcServiceController.create(this._serviceHubClient)
                        .then(function (controller) {
                        _this._controllers[DiagnosticsHub.DataWarehouse.Constants.CONTROLLER_ID_DATAWAREHOUSEJMCSERVICE] = controller;
                    }));
                    initializeControllersPromises.push(DiagnosticsHub.ActiveCollectionController.create(this._serviceHubClient)
                        .then(function (controller) {
                        _this._controllers[DiagnosticsHub.DataWarehouse.Constants.CONTROLLER_ID_DATAWAREHOUSEACTIVECOLLECTION] = controller;
                    }));
                    return Microsoft.Plugin.Promise.join(initializeControllersPromises);
                };
                DataWarehouseServiceHubHost.prototype.getController = function (controllerId) {
                    if (!this._controllers[controllerId]) {
                        throw new Error("Invalid controller ID");
                    }
                    return this._controllers[controllerId];
                };
                DataWarehouseServiceHubHost.DATAWAREHOUSE_HOST_RESPONSE_TYPE_SUCCESS = 1;
                DataWarehouseServiceHubHost.DATAWAREHOUSE_HOST_RESPONSE_TYPE_FAILURE = 2;
                DataWarehouseServiceHubHost.DATAWAREHOUSE_HOST_RESPONSE_TYPE_PENDING = 3;
                DataWarehouseServiceHubHost.DATAWAREHOUSE_HOST_RESPONSE_TYPE_CANCELED = 4;
                return DataWarehouseServiceHubHost;
            }());
            DiagnosticsHub.DataWarehouseServiceHubHost = DataWarehouseServiceHubHost;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var Guid = (function () {
                function Guid(value) {
                    if (value.length === 38 && value[0] === "{" && value[37] === "}") {
                        value = value.substr(1, 36);
                    }
                    if (value.length !== 36) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1010"));
                    }
                    this._value = value.toLowerCase();
                    if (!Guid.GuidRegEx.test(this._value)) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1010"));
                    }
                }
                Object.defineProperty(Guid, "empty", {
                    get: function () {
                        return new Guid("00000000-0000-0000-0000-000000000000");
                    },
                    enumerable: true,
                    configurable: true
                });
                Guid.newGuid = function () {
                    return new Guid(Guid.createRandomToken());
                };
                Guid.prototype.equals = function (other) {
                    return this._value.toLowerCase() === other._value.toLowerCase();
                };
                Guid.prototype.toString = function () {
                    return this._value;
                };
                Guid.createRandomToken = function () {
                    return "rrrrrrrr-rrrr-4rrr-srrr-rrrrrrrrrrrr".replace(/[rs]/g, function (character) {
                        var randomNumber = Math.random() * 16 | 0;
                        if (character !== "r") {
                            randomNumber = (randomNumber & 0x3 | 0x8);
                        }
                        return randomNumber.toString(16);
                    });
                };
                Guid.GuidRegEx = new RegExp("^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$");
                return Guid;
            }());
            DiagnosticsHub.Guid = Guid;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var Guids = (function () {
                function Guids() {
                }
                Object.defineProperty(Guids, "standardCollectorClassId", {
                    get: function () {
                        return "44d04ed9-f786-458c-93a9-7207a3cc52e1";
                    },
                    enumerable: true,
                    configurable: true
                });
                return Guids;
            }());
            DiagnosticsHub.Guids = Guids;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var OutputWindowsService = (function () {
                function OutputWindowsService() {
                    this._loggerProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.OutputWindowServiceMarshaler", {}, true);
                }
                OutputWindowsService.prototype.outputLine = function (message) {
                    this._loggerProxy._call("outputLine", message);
                };
                OutputWindowsService.prototype.outputLineAndShow = function (message) {
                    this._loggerProxy._call("outputLineAndShow", message);
                };
                OutputWindowsService.prototype.outputString = function (message) {
                    this._loggerProxy._call("outputString", message);
                };
                OutputWindowsService.prototype.outputStringAndShow = function (message) {
                    this._loggerProxy._call("outputStringAndShow", message);
                };
                return OutputWindowsService;
            }());
            var _outputWindowService = null;
            function getOutputWindowsService() {
                if (_outputWindowService === null) {
                    _outputWindowService = new OutputWindowsService();
                }
                return _outputWindowService;
            }
            DiagnosticsHub.getOutputWindowsService = getOutputWindowsService;
            Microsoft.Plugin.addEventListener("pluginready", function () {
                getOutputWindowsService();
            });
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var PerformanceDebuggerToolsService = (function () {
                function PerformanceDebuggerToolsService() {
                    this._proxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.PerformanceDebuggerToolsServiceMarshaler", {}, true);
                    this._toolStateChangedEvent = new DiagnosticsHub.ObservableEvent(this._proxy, "DiagnosticsHub.ToolStateChangedEvent");
                }
                Object.defineProperty(PerformanceDebuggerToolsService.prototype, "toolStateChangedEvent", {
                    get: function () {
                        return this._toolStateChangedEvent;
                    },
                    enumerable: true,
                    configurable: true
                });
                PerformanceDebuggerToolsService.prototype.getAvailableToolsInformationAndState = function () {
                    return this._proxy._call("getAvailableToolsInformation");
                };
                PerformanceDebuggerToolsService.prototype.setToolEnabled = function (toolId, active) {
                    this._proxy._call("setToolEnabled", toolId, active);
                };
                PerformanceDebuggerToolsService.prototype.invokeSettingsDialog = function () {
                    this._proxy._call("invokeSettingsDialog");
                };
                return PerformanceDebuggerToolsService;
            }());
            DiagnosticsHub.PerformanceDebuggerToolsService = PerformanceDebuggerToolsService;
            var _performanceDebuggerToolsService;
            function getPerformanceDebuggerToolsService() {
                if (!_performanceDebuggerToolsService) {
                    _performanceDebuggerToolsService = new PerformanceDebuggerToolsService();
                }
                return _performanceDebuggerToolsService;
            }
            DiagnosticsHub.getPerformanceDebuggerToolsService = getPerformanceDebuggerToolsService;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var ObservableEvent = (function () {
                function ObservableEvent(eventSource, eventName) {
                    this._eventName = eventName;
                    this._eventSource = eventSource;
                }
                ObservableEvent.prototype.addEventListener = function (func) {
                    this._eventSource.addEventListener(this._eventName, func);
                };
                ObservableEvent.prototype.removeEventListener = function (func) {
                    this._eventSource.removeEventListener(this._eventName, func);
                };
                return ObservableEvent;
            }());
            DiagnosticsHub.ObservableEvent = ObservableEvent;
            var PerformanceDebuggerEventManager = (function () {
                function PerformanceDebuggerEventManager() {
                    this._proxy = getPerformanceDebuggerStateMarshaler();
                    this._debugModeBreak = new ObservableEvent(this._proxy, "DebugModeBreakEvent");
                    this._debugModeRun = new ObservableEvent(this._proxy, "DebugModeRunEvent");
                }
                Object.defineProperty(PerformanceDebuggerEventManager.prototype, "debugModeRunEvent", {
                    get: function () {
                        return this._debugModeRun;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(PerformanceDebuggerEventManager.prototype, "debugModeBreakEvent", {
                    get: function () {
                        return this._debugModeBreak;
                    },
                    enumerable: true,
                    configurable: true
                });
                PerformanceDebuggerEventManager.prototype.isDebuggerInBreakMode = function () {
                    return this._proxy._call("isDebuggerInBreakMode");
                };
                return PerformanceDebuggerEventManager;
            }());
            var PerformanceDebuggerStateService = (function () {
                function PerformanceDebuggerStateService() {
                    this._proxy = getPerformanceDebuggerStateMarshaler();
                    this._statusMessageChanged = new ObservableEvent(this._proxy, "StatusMessageChangedEvent");
                }
                Object.defineProperty(PerformanceDebuggerStateService.prototype, "statusMessageChangedEvent", {
                    get: function () {
                        return this._statusMessageChanged;
                    },
                    enumerable: true,
                    configurable: true
                });
                PerformanceDebuggerStateService.prototype.getLastNonActiveStatusMessage = function () {
                    return this._proxy._call("getLastNonActiveStatusMessage");
                };
                PerformanceDebuggerStateService.prototype.isDocumentActiveSession = function () {
                    return this._proxy._call("isDocumentActiveSession");
                };
                return PerformanceDebuggerStateService;
            }());
            var _performanceDebuggerEventManager = null;
            function getPerformanceDebuggerEventManager() {
                if (_performanceDebuggerEventManager === null) {
                    _performanceDebuggerEventManager = new PerformanceDebuggerEventManager();
                }
                return _performanceDebuggerEventManager;
            }
            DiagnosticsHub.getPerformanceDebuggerEventManager = getPerformanceDebuggerEventManager;
            var _performanceDebuggerStateService = null;
            function getPerformanceDebuggerStateService() {
                if (_performanceDebuggerStateService === null) {
                    _performanceDebuggerStateService = new PerformanceDebuggerStateService();
                }
                return _performanceDebuggerStateService;
            }
            DiagnosticsHub.getPerformanceDebuggerStateService = getPerformanceDebuggerStateService;
            var _performanceDebuggerStateMarshaler = null;
            function getPerformanceDebuggerStateMarshaler() {
                if (_performanceDebuggerStateMarshaler === null) {
                    _performanceDebuggerStateMarshaler = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.PerformanceDebuggerStateMarshaler", {}, true);
                }
                return _performanceDebuggerStateMarshaler;
            }
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var jsonRpc = require("jsonRpc");
            var ServiceHubControllerBase = (function () {
                function ServiceHubControllerBase(channelStream, actionIdToOperationMap) {
                    this._rpc = jsonRpc.JsonRpcConnection.attach(channelStream);
                    this._actionIdToOperationMap = actionIdToOperationMap;
                }
                ServiceHubControllerBase.prototype.request = function (actionId, dataPayload) {
                    DiagnosticsHub.Debug.Assert.isNotUndefined(this._actionIdToOperationMap[actionId], "Unknown action ID");
                    return this._rpc.sendRequest(this._actionIdToOperationMap[actionId], [dataPayload]);
                };
                return ServiceHubControllerBase;
            }());
            DiagnosticsHub.ServiceHubControllerBase = ServiceHubControllerBase;
            var DataWarehouseController = (function (_super) {
                __extends(DataWarehouseController, _super);
                function DataWarehouseController() {
                    _super.apply(this, arguments);
                }
                DataWarehouseController.create = function (client) {
                    return client.requestService("DataWarehouseController")
                        .then(function (stream) {
                        return new DataWarehouseController(stream, DataWarehouseController.ActionIdToOperationMap);
                    });
                };
                DataWarehouseController.ActionIdToOperationMap = {
                    1: "BeginInitialization",
                    2: "EndInitialization",
                    3: "GetData",
                    4: "GetResult",
                    5: "DisposeResult",
                    6: "PushDataSources",
                    7: "PushActiveCollectionDataSource",
                    8: "CompleteActiveCollectionDataSource",
                    9: "RetrieveDataBlob",
                    10: "StoreDataBlob",
                    11: "DeleteDataBlob",
                    12: "SymbolResolverConfigurationUpdate",
                    400: "Close",
                    401: "GetPrivateData",
                    402: "SetPrivateData",
                    403: "GetStatus",
                    404: "CancelTask",
                    405: "AbortAnalysis"
                };
                return DataWarehouseController;
            }(ServiceHubControllerBase));
            DiagnosticsHub.DataWarehouseController = DataWarehouseController;
            var ContextServiceController = (function (_super) {
                __extends(ContextServiceController, _super);
                function ContextServiceController() {
                    _super.apply(this, arguments);
                }
                ContextServiceController.create = function (client) {
                    return client.requestService("DataWarehouseContextServiceController")
                        .then(function (stream) {
                        return new ContextServiceController(stream, ContextServiceController.ActionIdToOperationMap);
                    });
                };
                ContextServiceController.ActionIdToOperationMap = {
                    1: "CreateContext",
                    2: "DeleteContext",
                    3: "CopyContext",
                    4: "GetContext",
                    5: "GetGlobalContext"
                };
                return ContextServiceController;
            }(ServiceHubControllerBase));
            DiagnosticsHub.ContextServiceController = ContextServiceController;
            var ContextController = (function (_super) {
                __extends(ContextController, _super);
                function ContextController() {
                    _super.apply(this, arguments);
                }
                ContextController.create = function (client) {
                    return client.requestService("DataWarehouseContextController")
                        .then(function (stream) {
                        return new ContextController(stream, ContextController.ActionIdToOperationMap);
                    });
                };
                ContextController.ActionIdToOperationMap = {
                    1: "GetTimeDomain",
                    2: "SetTimeDomain",
                    3: "GetMachineDomain",
                    4: "AddMachineDomain",
                    5: "ClearMachineDomain",
                    6: "GetProcessDomain",
                    7: "AddProcessDomain",
                    8: "ClearProcessDomain",
                    9: "GetThreadDomain",
                    10: "AddThreadDomain",
                    11: "ClearThreadDomain",
                    12: "GetCustomDomain",
                    13: "SetCustomDomain",
                    14: "GetData",
                    15: "SetData"
                };
                return ContextController;
            }(ServiceHubControllerBase));
            DiagnosticsHub.ContextController = ContextController;
            var JmcServiceController = (function (_super) {
                __extends(JmcServiceController, _super);
                function JmcServiceController() {
                    _super.apply(this, arguments);
                }
                JmcServiceController.create = function (client) {
                    return client.requestService("DataWarehouseJmcServiceController")
                        .then(function (stream) {
                        return new JmcServiceController(stream, JmcServiceController.ActionIdToOperationMap);
                    });
                };
                JmcServiceController.ActionIdToOperationMap = {
                    1: "GetJmc",
                    2: "SetJmc"
                };
                return JmcServiceController;
            }(ServiceHubControllerBase));
            DiagnosticsHub.JmcServiceController = JmcServiceController;
            var ActiveCollectionController = (function (_super) {
                __extends(ActiveCollectionController, _super);
                function ActiveCollectionController() {
                    _super.apply(this, arguments);
                }
                ActiveCollectionController.create = function (client) {
                    return client.requestService("DataWarehouseActiveCollectionController")
                        .then(function (stream) {
                        return new ActiveCollectionController(stream, ActiveCollectionController.ActionIdToOperationMap);
                    });
                };
                ActiveCollectionController.ActionIdToOperationMap = {
                    1: "NewTargetProcess",
                    2: "GraphUpdates"
                };
                return ActiveCollectionController;
            }(ServiceHubControllerBase));
            DiagnosticsHub.ActiveCollectionController = ActiveCollectionController;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var Collectors;
            (function (Collectors) {
                "use strict";
                var CollectorTransportServiceController = (function () {
                    function CollectorTransportServiceController(logger) {
                        var _this = this;
                        this._messageListeners = {};
                        this._logger = logger;
                        this._proxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.CollectorTransportServiceControllerMarshaler", {}, true);
                        this._proxy.addEventListener("stringMessageReceived", function (eventArgs) {
                            _this.onStringMessageReceived(eventArgs);
                        });
                    }
                    CollectorTransportServiceController.prototype.sendStringToCollectionAgent = function (agentClassId, request, collectorId) {
                        return this._proxy._call("sendStringToCollectionAgent", agentClassId, request, collectorId || DiagnosticsHub.Guids.standardCollectorClassId);
                    };
                    CollectorTransportServiceController.prototype.downloadFile = function (targetFilePath, localFilePath, collectorId) {
                        return this._proxy._call("downloadFile", targetFilePath, localFilePath, collectorId || DiagnosticsHub.Guids.standardCollectorClassId);
                    };
                    CollectorTransportServiceController.prototype.addMessageListener = function (listenerGuid, listener, collectorId) {
                        var _this = this;
                        var guidAsString = listenerGuid.toString();
                        this._logger.debug("Adding message listener (" + guidAsString + ") for collector " + collectorId || DiagnosticsHub.Guids.standardCollectorClassId);
                        if (this._messageListeners[guidAsString]) {
                            this._logger.error("Listener already exists with guid = " + guidAsString);
                            throw new Error("Listener already exists with guid = " + guidAsString);
                        }
                        this._messageListeners[guidAsString] = listener;
                        return this._proxy._call("enableEventsForListenerId", guidAsString, collectorId || DiagnosticsHub.Guids.standardCollectorClassId)
                            .then(null, function (value) {
                            _this._messageListeners[guidAsString] = null;
                            _this._logger.error(JSON.stringify(value));
                        });
                    };
                    CollectorTransportServiceController.prototype.onStringMessageReceived = function (eventArgs) {
                        var listenerGuid = eventArgs.ListenerId;
                        var message = eventArgs.Message;
                        if (this._messageListeners[listenerGuid]) {
                            var listener = this._messageListeners[listenerGuid];
                            listener(message);
                        }
                        else {
                            this._logger.warning("Unexpected message received without a message listener - ID: " + listenerGuid);
                        }
                    };
                    return CollectorTransportServiceController;
                }());
                var _collectorTransportServiceController = null;
                function getCollectorTransportServiceController() {
                    if (_collectorTransportServiceController === null) {
                        _collectorTransportServiceController = new CollectorTransportServiceController(DiagnosticsHub.getLogger());
                    }
                    return _collectorTransportServiceController;
                }
                Collectors.getCollectorTransportServiceController = getCollectorTransportServiceController;
                function getStandardTransportService() {
                    return getCollectorTransportServiceController();
                }
                Collectors.getStandardTransportService = getStandardTransportService;
            })(Collectors = DiagnosticsHub.Collectors || (DiagnosticsHub.Collectors = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var DataWarehouseNativeHost = (function () {
                function DataWarehouseNativeHost(logger) {
                    this._externalObject = null;
                    this._logger = logger;
                    var hostObj = Microsoft.Plugin.F12 || Microsoft.Plugin.VS;
                    if (!hostObj) {
                        this._logger.error("External object creator does not exist");
                        throw "Unable to determine the ScriptedSandbox host";
                    }
                    this._externalObject = hostObj.Utilities.createExternalObject("DiagnosticsHub.DataWarehouseHost", "{339B3787-FC17-4BF5-A0DC-CBEF24DB2EDE}");
                    this._automationManager = DiagnosticsHub.getAutomationManager(this._logger);
                }
                DataWarehouseNativeHost.prototype.requestSync = function (controllerId, actionId, sessionId, request) {
                    if (this._externalObject) {
                        this._externalObject.requestSync(controllerId, actionId, sessionId, (typeof request === "string") ? request : (request !== null && (typeof request !== "undefined")) ? JSON.stringify(request) : "");
                    }
                    else {
                        this._logger.warning("External object is null. Verify that DiagnosticsHub.ScriptedSandboxPlugin.dll was loaded into ScriptedSandbox.");
                    }
                };
                DataWarehouseNativeHost.prototype.request = function (controllerId, actionId, sessionId, request) {
                    var _this = this;
                    var safeInvoke = function (callback, response) {
                        try {
                            callback(response);
                        }
                        catch (e) {
                            _this._logger.error(JSON.stringify(e));
                        }
                    };
                    var result = null;
                    var response = null;
                    var oncancel = function () {
                        if (_this._externalObject && _this._externalObject.cancel && response && response.requestId) {
                            _this._externalObject.cancel(response.requestId);
                        }
                    };
                    var dispatchCallback = function (promiseHandler, jsonResponse, promiseType) {
                        if (promiseHandler !== null) {
                            var result = null;
                            if (jsonResponse !== null) {
                                try {
                                    result = (jsonResponse === null || jsonResponse === "" || (typeof jsonResponse !== "string")) ? jsonResponse : JSON.parse(jsonResponse);
                                }
                                catch (e) {
                                    _this._logger.error("Could not parse " + promiseType + " response: " + jsonResponse);
                                    _this._logger.error(e.Message);
                                }
                            }
                            safeInvoke(promiseHandler, result);
                        }
                        else {
                            _this._logger.warning("DataWarehouseNativeHost: " + promiseType + " callback is null.");
                        }
                    };
                    var promiseInitialization = function (completePromise, errorPromise, progressPromise) {
                        if (_this._externalObject) {
                            result = _this._externalObject.request(controllerId, actionId, sessionId, (typeof request === "string") ? request : (request !== null && (typeof request !== "undefined")) ? JSON.stringify(request) : "", function (jsonResponse) {
                                dispatchCallback(completePromise, jsonResponse, "completePromise");
                            }, function (jsonResponse) {
                                dispatchCallback(errorPromise, jsonResponse, "errorPromise");
                            }, function (jsonResponse) {
                                dispatchCallback(progressPromise, jsonResponse, "progressPromise");
                            });
                        }
                        else {
                            _this._logger.warning("External object is null. Verify that DiagnosticsHub.ScriptedSandboxPlugin.dll was loaded into ScriptedSandbox.");
                        }
                        if (result === null || typeof result !== "string") {
                            response = { hresult: 1 };
                        }
                        else {
                            response = JSON.parse(result);
                        }
                        if (response.hresult !== 0) {
                            _this._logger.error("Could not invoke request method of native host: " + result);
                            var error = new Error();
                            error.message = error.name = response.hresult.toString(16);
                            errorPromise(error);
                        }
                    };
                    var requestArgs = {
                        controllerId: controllerId,
                        actionId: actionId,
                        sessionId: sessionId,
                        request: request
                    };
                    var resultPromise = this._automationManager.getAutomationPromise(DiagnosticsHub.AutomationConstants.DataWarehouseRequestKey, promiseInitialization, oncancel, requestArgs);
                    return resultPromise;
                };
                return DataWarehouseNativeHost;
            }());
            DiagnosticsHub.DataWarehouseNativeHost = DataWarehouseNativeHost;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var DataWarehouse;
            (function (DataWarehouse) {
                "use strict";
                var ResourceIdentity = (function () {
                    function ResourceIdentity() {
                    }
                    ResourceIdentity.DiagnosticsPackage = "DiagnosticsHub.Resource.DiagnosticsPackage";
                    ResourceIdentity.EtlFile = "DiagnosticsHub.Resource.EtlFile";
                    ResourceIdentity.JavaScriptSource = "DiagnosticsHub.Resource.JavaScript.SourceDirectory";
                    ResourceIdentity.SymbolCache = "DiagnosticsHub.Resource.SymbolCache";
                    ResourceIdentity.UserNativeImageDirectory = "DiagnosticsHub.Resource.UserNativeImageDirectory";
                    ResourceIdentity.PlatformNativeImage = "DiagnosticsHub.Resource.PlatformNativeImage";
                    ResourceIdentity.PlatformWinmd = "DiagnosticsHub.Resource.PlatformWinmd";
                    ResourceIdentity.CountersFile = "DiagnosticsHub.Resource.CountersFile";
                    ResourceIdentity.DWJsonFile = "DiagnosticsHub.Resource.DWJsonFile";
                    ResourceIdentity.UnknownFile = "DiagnosticsHub.Resource.File";
                    ResourceIdentity.UnknownDirectory = "DiagnosticsHub.Resource.Directory";
                    return ResourceIdentity;
                }());
                DataWarehouse.ResourceIdentity = ResourceIdentity;
            })(DataWarehouse = DiagnosticsHub.DataWarehouse || (DiagnosticsHub.DataWarehouse = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var DataWarehouse;
            (function (DataWarehouse) {
                "use strict";
                var Constants = (function () {
                    function Constants() {
                    }
                    Constants.CONTROLLER_ID_DATAWAREHOUSE = 1;
                    Constants.CONTROLLER_ID_DATAWAREHOUSECONTEXTSERVICE = 2;
                    Constants.CONTROLLER_ID_DATAWAREHOUSECONTEXT = 3;
                    Constants.CONTROLLER_ID_DATAWAREHOUSEJMCSERVICE = 4;
                    Constants.CONTROLLER_ID_DATAWAREHOUSEACTIVECOLLECTION = 5;
                    Constants.ACTION_DATAWAREHOUSE_BEGININITIALIZATION = 1;
                    Constants.ACTION_DATAWAREHOUSE_ENDINITIALIZATION = 2;
                    Constants.ACTION_DATAWAREHOUSE_GETDATA = 3;
                    Constants.ACTION_DATAWAREHOUSE_GETRESULT = 4;
                    Constants.ACTION_DATAWAREHOUSE_DISPOSERESULT = 5;
                    Constants.ACTION_DATAWAREHOUSE_PUSHDATASOURCES = 6;
                    Constants.ACTION_DATAWAREHOUSE_PUSHACTIVECOLLECTIONDATASOURCE = 7;
                    Constants.ACTION_DATAWAREHOUSE_COMPLETEACTIVECOLLECTIONDATASOURCE = 8;
                    Constants.ACTION_DATAWAREHOUSE_RETRIEVEDATABLOB = 9;
                    Constants.ACTION_DATAWAREHOUSE_STOREDATABLOB = 10;
                    Constants.ACTION_DATAWAREHOUSE_DELETEDATABLOB = 11;
                    Constants.ACTION_DATAWAREHOUSE_SYMBOLRESOLVERCONFIGURATIONUPDATE = 12;
                    Constants.ACTION_DATAWAREHOUSE_INITIALIZATION_DEPRECATED = 100;
                    Constants.ACTION_DATAWAREHOUSE_CLOSE = 400;
                    Constants.ACTION_DATAWAREHOUSE_GETPRIVATEDATA = 401;
                    Constants.ACTION_DATAWAREHOUSE_SETPRIVATEDATA = 402;
                    Constants.ACTION_DATAWAREHOUSE_GETSTATUS = 403;
                    Constants.ACTION_DATAWAREHOUSE_CANCELTASK = 404;
                    Constants.ACTION_DATAWAREHOUSE_ABORTANALYSIS = 405;
                    Constants.ACTION_DATAWAREHOUSECONTEXTSERVICE_CREATECONTEXT = 1;
                    Constants.ACTION_DATAWAREHOUSECONTEXTSERVICE_DELETECONTEXT = 2;
                    Constants.ACTION_DATAWAREHOUSECONTEXTSERVICE_COPYCONTEXT = 3;
                    Constants.ACTION_DATAWAREHOUSECONTEXTSERVICE_GETCONTEXT = 4;
                    Constants.ACTION_DATAWAREHOUSECONTEXTSERVICE_GETGLOBALCONTEXT = 5;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_GETTIMEDOMAIN = 1;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_SETTIMEDOMAIN = 2;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_GETMACHINEDOMAIN = 3;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_ADDTOMACHINEDOMAIN = 4;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_CLEARMACHINEDOMAIN = 5;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_GETPROCESSDOMAIN = 6;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_ADDTOPROCESSDOMAIN = 7;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_CLEARPROCESSDOMAIN = 8;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_GETTHREADDOMAIN = 9;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_ADDTOTHREADDOMAIN = 10;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_CLEARTHREADDOMAIN = 11;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_GETCUSTOMDOMAIN = 12;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_SETCUSTOMDOMAIN = 13;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_GETDATA = 14;
                    Constants.ACTION_DATAWAREHOUSECONTEXT_SETDATA = 15;
                    Constants.ACTION_DATAWAREHOUSEJMCSERVICE_GETJMCENABLED = 1;
                    Constants.ACTION_DATAWAREHOUSEJMCSERVICE_SETJMCENABLED = 2;
                    Constants.ACTION_DATAWAREHOUSEACTIVECOLLECTION_NEWTARGETPROCESS = 1;
                    Constants.ACTION_DATAWAREHOUSEACTIVECOLLECTION_GRAPHUPDATES = 2;
                    return Constants;
                }());
                DataWarehouse.Constants = Constants;
                var DhJsonResult = (function () {
                    function DhJsonResult(resultId, sessionId, controller) {
                        this._resultId = resultId;
                        this._sessionId = sessionId;
                        this._controller = controller;
                    }
                    Object.defineProperty(DhJsonResult.prototype, "resultId", {
                        get: function () {
                            return this._resultId;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    DhJsonResult.prototype.getResult = function (customData) {
                        var requestObject = null;
                        if (customData !== null) {
                            requestObject = { resultId: this._resultId, customData: JSON.stringify(customData) };
                        }
                        else {
                            requestObject = { resultId: this._resultId };
                        }
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSE_GETRESULT, requestObject);
                    };
                    DhJsonResult.prototype.dispose = function () {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSE_DISPOSERESULT, { resultId: this._resultId });
                    };
                    return DhJsonResult;
                }());
                var DataWarehouseFactory = (function () {
                    function DataWarehouseFactory() {
                        this._getConfigurationPromise = null;
                        this._serviceProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.DataWarehouseServiceMarshaler", {}, true);
                        this._logger = DiagnosticsHub.getLogger();
                    }
                    DataWarehouseFactory.prototype.getDataWarehouse = function (configuration) {
                        var _this = this;
                        if (configuration === void 0) { configuration = null; }
                        if (this._getConfigurationPromise === null || configuration) {
                            if (configuration === null) {
                                this._getConfigurationPromise = this._serviceProxy._call("getDataWarehouseConfiguration");
                            }
                            else {
                                this._getConfigurationPromise = Microsoft.Plugin.Promise.wrap(configuration);
                            }
                        }
                        return this._getConfigurationPromise.then(function (configuration) {
                            _this._logger.debug("Got the sessionId '" + configuration.sessionId + "'. Creating datawarehouse...");
                            return new DataWarehouseInstance(configuration);
                        });
                    };
                    return DataWarehouseFactory;
                }());
                DataWarehouse.DataWarehouseFactory = DataWarehouseFactory;
                var DataWarehouseInstance = (function () {
                    function DataWarehouseInstance(dwConfiguration) {
                        this._logger = null;
                        this._dwConfiguration = null;
                        this._controller = null;
                        this._contextService = null;
                        this._jmcService = null;
                        this._logger = DiagnosticsHub.getLogger();
                        this._dwConfiguration = dwConfiguration;
                        this._controller = new DiagnosticsHub.HostController(this._dwConfiguration.sessionId, Constants.CONTROLLER_ID_DATAWAREHOUSE);
                    }
                    DataWarehouseInstance.prototype.getConfiguration = function () {
                        return this._dwConfiguration;
                    };
                    DataWarehouseInstance.prototype.getData = function (contextId, analyzerId) {
                        var jsonRequest;
                        if (!contextId) {
                            jsonRequest = { analyzerId: analyzerId };
                        }
                        else {
                            jsonRequest = { contextId: contextId, analyzerId: analyzerId };
                        }
                        return this.getDataFromAnalyzer(jsonRequest);
                    };
                    DataWarehouseInstance.prototype.getFilteredData = function (filter, analyzerId) {
                        return this.getDataFromAnalyzer({ filter: serializeDhContextData(null, filter), analyzerId: analyzerId });
                    };
                    DataWarehouseInstance.prototype.getResultId = function (result) {
                        var resultInstance = result;
                        if (!resultInstance.resultId) {
                            throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1011"));
                        }
                        return resultInstance.resultId;
                    };
                    DataWarehouseInstance.prototype.getResultById = function (resultId) {
                        return new DhJsonResult(resultId, this._dwConfiguration.sessionId, this._controller);
                    };
                    DataWarehouseInstance.prototype.getContextService = function () {
                        if (!this._contextService) {
                            this._contextService = new DhContextService(this._dwConfiguration.sessionId);
                        }
                        return this._contextService;
                    };
                    DataWarehouseInstance.prototype.getJmcService = function () {
                        if (!this._jmcService) {
                            this._jmcService = new JmcService(this._dwConfiguration.sessionId);
                        }
                        return this._jmcService;
                    };
                    DataWarehouseInstance.prototype.close = function () {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSE_CLOSE);
                    };
                    DataWarehouseInstance.prototype.closeSynchronous = function () {
                        if (Microsoft.Plugin.F12) {
                            this._controller.requestSync(Constants.ACTION_DATAWAREHOUSE_CLOSE);
                        }
                        else {
                            throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1009"));
                        }
                    };
                    DataWarehouseInstance.prototype.initialize = function () {
                        this._logger.debug("Initializing DataWarehouse...");
                        var jsonConfiguration = {
                            analyzers: this._dwConfiguration.analyzers,
                            dataSources: this._dwConfiguration.dataSources,
                            symbolStorePath: this._dwConfiguration.symbolStorePath || "",
                            symbolCachePath: this._dwConfiguration.symbolCachePath || "",
                            isJmcEnabled: (typeof this._dwConfiguration.isJmcEnabled === "undefined") ? true : this._dwConfiguration.isJmcEnabled,
                        };
                        this._logger.debug("DataWarehouse configuration: " + JSON.stringify(jsonConfiguration));
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSE_INITIALIZATION_DEPRECATED, jsonConfiguration);
                    };
                    DataWarehouseInstance.prototype.beginInitialization = function () {
                        this._logger.debug("Begin initializing DataWarehouse");
                        var jsonConfiguration = {
                            analyzers: this._dwConfiguration.analyzers,
                            dataSources: this._dwConfiguration.dataSources,
                            symbolStorePath: this._dwConfiguration.symbolStorePath || "",
                            symbolCachePath: this._dwConfiguration.symbolCachePath || "",
                            isJmcEnabled: (typeof this._dwConfiguration.isJmcEnabled === "undefined") ? true : this._dwConfiguration.isJmcEnabled,
                            symbolLocatorServiceFullPath: this._dwConfiguration.symbolLocatorServiceFullPath || "",
                            portablePdbLibraryFullPath: this._dwConfiguration.portablePdbLibraryFullPath || "",
                        };
                        this._logger.debug("DataWarehouse configuration: " + JSON.stringify(jsonConfiguration));
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSE_BEGININITIALIZATION, jsonConfiguration);
                    };
                    DataWarehouseInstance.prototype.pushDataSources = function (dataSources) {
                        this._logger.debug("Begin pushing data source(s) to DataWarehouse");
                        var payload = {
                            dataSources: dataSources
                        };
                        this._logger.debug("PushDataSources payload: " + JSON.stringify(payload));
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSE_PUSHDATASOURCES, payload);
                    };
                    DataWarehouseInstance.prototype.endInitialization = function () {
                        this._logger.debug("End initializing DataWarehouse");
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSE_ENDINITIALIZATION);
                    };
                    DataWarehouseInstance.prototype.getPrivateData = function (dataId, privateDataArg) {
                        this._logger.debug("Getting private data from DataWarehouse...");
                        var privateDataRequest = { id: dataId, dataArg: privateDataArg };
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSE_GETPRIVATEDATA, privateDataRequest);
                    };
                    DataWarehouseInstance.prototype.setPrivateData = function (dataId, privateData) {
                        this._logger.debug("Setting private data in DataWarehouse...");
                        var privateDataRequest = { id: dataId, data: privateData };
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSE_SETPRIVATEDATA, privateDataRequest);
                    };
                    DataWarehouseInstance.prototype.getDataFromAnalyzer = function (jsonRequest) {
                        var _this = this;
                        var completePromise;
                        var errorPromise;
                        var progressPromise;
                        var promiseInitialization = function (completed, error, progress) {
                            completePromise = completed;
                            errorPromise = error;
                            progressPromise = progress;
                        };
                        var requestPromise = this._controller.request(Constants.ACTION_DATAWAREHOUSE_GETDATA, jsonRequest).then(function (result) {
                            var val = null;
                            if (result !== null && typeof result !== "undefined" && typeof result.dh_r_id === "number") {
                                _this._logger.debug("Result ID (" + result.dh_r_id + ") received for Session ID: " + _this._dwConfiguration.sessionId);
                                val = new DhJsonResult(result.dh_r_id, _this._dwConfiguration.sessionId, _this._controller);
                            }
                            else {
                                val = result;
                            }
                            completePromise(val);
                        }, function (error) {
                            if (errorPromise) {
                                errorPromise(error);
                            }
                        }, function (progress) {
                            if (progress) {
                                progressPromise(progress);
                            }
                        });
                        var oncancel = function () {
                            requestPromise.cancel();
                        };
                        return new Microsoft.Plugin.Promise(promiseInitialization, oncancel);
                    };
                    return DataWarehouseInstance;
                }());
                function serializeDhContextData(contextId, data) {
                    var result = {};
                    if (contextId) {
                        result["contextId"] = contextId;
                    }
                    if (data.timeDomain) {
                        result["timeDomain"] = {
                            begin: data.timeDomain.begin.jsonValue,
                            end: data.timeDomain.end.jsonValue
                        };
                    }
                    if (data.machineDomain) {
                        result["machineDomain"] = data.machineDomain;
                    }
                    if (data.processDomain) {
                        result["processDomain"] = data.processDomain;
                    }
                    if (data.threadDomain) {
                        result["threadDomain"] = data.threadDomain;
                    }
                    if (data.customDomain) {
                        result["customDomain"] = data.customDomain;
                    }
                    return result;
                }
                var DhContextService = (function () {
                    function DhContextService(sessionId) {
                        this._controller = new DiagnosticsHub.HostController(sessionId, Constants.CONTROLLER_ID_DATAWAREHOUSECONTEXTSERVICE);
                        this._sessionId = sessionId;
                    }
                    DhContextService.prototype.createContext = function (data) {
                        var _this = this;
                        var request = {};
                        if (data !== null && typeof data !== "undefined") {
                            request["data"] = serializeDhContextData(null, data);
                        }
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXTSERVICE_CREATECONTEXT, request)
                            .then(function (contextInfo) {
                            return new DhContext(contextInfo, _this._sessionId);
                        });
                    };
                    DhContextService.prototype.deleteContext = function (contextId) {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXTSERVICE_DELETECONTEXT, { contextId: contextId });
                    };
                    DhContextService.prototype.copyContext = function (contextId) {
                        var _this = this;
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXTSERVICE_COPYCONTEXT, { contextId: contextId })
                            .then(function (contextInfo) {
                            return new DhContext(contextInfo, _this._sessionId);
                        });
                    };
                    DhContextService.prototype.getContext = function (contextId) {
                        var _this = this;
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXTSERVICE_GETCONTEXT, { contextId: contextId })
                            .then(function (contextInfo) {
                            return new DhContext(contextInfo, _this._sessionId);
                        });
                    };
                    DhContextService.prototype.getGlobalContext = function () {
                        var _this = this;
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXTSERVICE_GETGLOBALCONTEXT)
                            .then(function (contextInfo) {
                            return new DhContext(contextInfo, _this._sessionId);
                        });
                    };
                    return DhContextService;
                }());
                var DhContext = (function () {
                    function DhContext(contextInfo, sessionId) {
                        this._info = contextInfo;
                        this._sessionId = sessionId;
                        this._controller = new DiagnosticsHub.HostController(this._sessionId, Constants.CONTROLLER_ID_DATAWAREHOUSECONTEXT);
                    }
                    DhContext.prototype.getContextId = function () {
                        return this._info.contextId;
                    };
                    DhContext.prototype.getParentContextId = function () {
                        return this._info.parentContextId;
                    };
                    DhContext.prototype.setData = function (data) {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_SETDATA, serializeDhContextData(this._info.contextId, data));
                    };
                    DhContext.prototype.getData = function () {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_GETDATA, { contextId: this._info.contextId })
                            .then(function (result) {
                            return {
                                timeDomain: new DiagnosticsHub.JsonTimespan(new DiagnosticsHub.BigNumber(result.timeDomain.begin.h, result.timeDomain.begin.l), new DiagnosticsHub.BigNumber(result.timeDomain.end.h, result.timeDomain.end.l)),
                                machineDomain: result.machineDomain,
                                processDomain: result.processDomain,
                                threadDomain: result.threadDomain,
                                customDomain: result.customDomain
                            };
                        });
                    };
                    DhContext.prototype.getTimeDomain = function () {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_GETTIMEDOMAIN, { contextId: this._info.contextId })
                            .then(function (result) {
                            return new DiagnosticsHub.JsonTimespan(new DiagnosticsHub.BigNumber(result.begin.h, result.begin.l), new DiagnosticsHub.BigNumber(result.end.h, result.end.l));
                        });
                    };
                    DhContext.prototype.setTimeDomain = function (timeDomain) {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_SETTIMEDOMAIN, {
                            contextId: this._info.contextId,
                            timeDomain: {
                                begin: timeDomain.begin.jsonValue,
                                end: timeDomain.end.jsonValue
                            }
                        });
                    };
                    DhContext.prototype.getMachineDomain = function () {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_GETMACHINEDOMAIN, { contextId: this._info.contextId });
                    };
                    DhContext.prototype.addToMachineDomain = function (machineName) {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_ADDTOMACHINEDOMAIN, { contextId: this._info.contextId, machineName: machineName });
                    };
                    DhContext.prototype.clearMachineDomain = function () {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_CLEARMACHINEDOMAIN, { contextId: this._info.contextId });
                    };
                    DhContext.prototype.getProcessDomain = function () {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_GETPROCESSDOMAIN, { contextId: this._info.contextId });
                    };
                    DhContext.prototype.addToProcessDomain = function (processId) {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_ADDTOPROCESSDOMAIN, { contextId: this._info.contextId, processId: processId });
                    };
                    DhContext.prototype.clearProcessDomain = function () {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_CLEARPROCESSDOMAIN, { contextId: this._info.contextId });
                    };
                    DhContext.prototype.getThreadDomain = function () {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_GETTHREADDOMAIN, { contextId: this._info.contextId });
                    };
                    DhContext.prototype.addToThreadDomain = function (threadId) {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_ADDTOTHREADDOMAIN, { contextId: this._info.contextId, threadId: threadId });
                    };
                    DhContext.prototype.clearThreadDomain = function () {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_CLEARTHREADDOMAIN, { contextId: this._info.contextId });
                    };
                    DhContext.prototype.getCustomDomain = function (name) {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_GETCUSTOMDOMAIN, { contextId: this._info.contextId, name: name })
                            .then(function (result) {
                            return result.value;
                        });
                    };
                    DhContext.prototype.setCustomDomain = function (name, value) {
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSECONTEXT_SETCUSTOMDOMAIN, { contextId: this._info.contextId, name: name, value: value });
                    };
                    return DhContext;
                }());
                var JmcService = (function () {
                    function JmcService(sessionId) {
                        this._controller = new DiagnosticsHub.HostController(sessionId, Constants.CONTROLLER_ID_DATAWAREHOUSEJMCSERVICE);
                        this._logger = DiagnosticsHub.getLogger();
                        this._viewEventManager = Microsoft.VisualStudio.DiagnosticsHub.getViewEventManager();
                    }
                    JmcService.prototype.getJmcEnabledState = function () {
                        var _this = this;
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSEJMCSERVICE_GETJMCENABLED)
                            .then(function (result) {
                            if (typeof result.jmcOn === "undefined") {
                                _this._logger.error("getJmcEnabledState() result is ill-formed");
                                throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.9999"));
                            }
                            return result.jmcOn;
                        });
                    };
                    JmcService.prototype.setJmcEnabledState = function (enabledState) {
                        var _this = this;
                        return this._controller.request(Constants.ACTION_DATAWAREHOUSEJMCSERVICE_SETJMCENABLED, { jmcOn: enabledState })
                            .then(function (result) {
                            if (typeof result.prevEnabledState === "undefined" || typeof result.currEnabledState === "undefined") {
                                _this._logger.error("setJmcEnabledState() result is ill-formed");
                                throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.9999"));
                            }
                            if (result.prevEnabledState !== result.currEnabledState) {
                                _this._viewEventManager.jmcEnabledStateChanged.raiseEvent(result);
                            }
                        });
                    };
                    return JmcService;
                }());
                var _dwFactory = null;
                function loadDataWarehouse(configuration) {
                    if (configuration === void 0) { configuration = null; }
                    if (_dwFactory === null) {
                        _dwFactory = new DataWarehouseFactory();
                    }
                    return _dwFactory.getDataWarehouse(configuration);
                }
                DataWarehouse.loadDataWarehouse = loadDataWarehouse;
            })(DataWarehouse = DiagnosticsHub.DataWarehouse || (DiagnosticsHub.DataWarehouse = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var Controllers;
            (function (Controllers) {
                "use strict";
                var F12_JMCType;
                (function (F12_JMCType) {
                    F12_JMCType[F12_JMCType["UserCode"] = 0] = "UserCode";
                    F12_JMCType[F12_JMCType["Library"] = 1] = "Library";
                    F12_JMCType[F12_JMCType["Unrelated"] = 2] = "Unrelated";
                    F12_JMCType[F12_JMCType["Unsure"] = 3] = "Unsure";
                })(F12_JMCType || (F12_JMCType = {}));
                var JavaScriptJmc = (function () {
                    function JavaScriptJmc() {
                        this._serviceProxy = getVisualStudioService();
                    }
                    JavaScriptJmc.prototype.getJmcTypeForUrls = function (urls) {
                        if (Microsoft.Plugin.F12) {
                            return Microsoft.Plugin.F12.JMC.getJMCTypeForUrls(urls).then(function (jmcTypes) {
                                if (!jmcTypes) {
                                    return [];
                                }
                                for (var i = 0; i < jmcTypes.length; ++i) {
                                    switch (jmcTypes[i]) {
                                        case F12_JMCType.UserCode:
                                            jmcTypes[i] = 0;
                                            break;
                                        case F12_JMCType.Library:
                                            jmcTypes[i] = 1;
                                            break;
                                        case F12_JMCType.Unrelated:
                                            jmcTypes[i] = 2;
                                            break;
                                        case F12_JMCType.Unsure:
                                            jmcTypes[i] = -1;
                                            break;
                                        default:
                                            jmcTypes[i] = -1;
                                            break;
                                    }
                                }
                                return jmcTypes;
                            });
                        }
                        else {
                            return this._serviceProxy._call("getJMCTypeForUrls", urls);
                        }
                    };
                    return JavaScriptJmc;
                }());
                Controllers.JavaScriptJmc = JavaScriptJmc;
                var SolutionService = (function () {
                    function SolutionService() {
                        this._serviceProxy = getVisualStudioService();
                    }
                    SolutionService.prototype.getAllExecutableCodeOutputs = function (includeFilenameExtensions) {
                        return this._serviceProxy._call("getSolutionExecutableCodeOutputs", includeFilenameExtensions);
                    };
                    return SolutionService;
                }());
                Controllers.SolutionService = SolutionService;
                var SourceService = (function () {
                    function SourceService() {
                        this._serviceProxy = getVisualStudioService();
                    }
                    SourceService.prototype.showDocument = function (filename, linenumber) {
                        return this._serviceProxy._call("showDocument", filename, linenumber);
                    };
                    SourceService.prototype.getAccessiblePathToFile = function (filename) {
                        return this._serviceProxy._call("getAccessiblePathToFile", filename);
                    };
                    return SourceService;
                }());
                Controllers.SourceService = SourceService;
                var DataWarehouseRegistryService = (function () {
                    function DataWarehouseRegistryService() {
                        this._serviceProxy = getVisualStudioService();
                    }
                    DataWarehouseRegistryService.prototype.isDataWarehouseInVsHub = function () {
                        return this._serviceProxy._call("isDataWarehouseInVsHub");
                    };
                    return DataWarehouseRegistryService;
                }());
                Controllers.DataWarehouseRegistryService = DataWarehouseRegistryService;
                var _visualStudioServiceProxy = null;
                function getVisualStudioService() {
                    if (_visualStudioServiceProxy === null) {
                        _visualStudioServiceProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.VisualStudioServiceMarshaler", {}, true);
                    }
                    return _visualStudioServiceProxy;
                }
                Controllers.getVisualStudioService = getVisualStudioService;
            })(Controllers = DiagnosticsHub.Controllers || (DiagnosticsHub.Controllers = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var DocumentClosingEventDeferral = (function () {
                function DocumentClosingEventDeferral(onHandlerCompleted) {
                    this._onHandlerCompleted = onHandlerCompleted;
                }
                DocumentClosingEventDeferral.prototype.complete = function (result) {
                    this._onHandlerCompleted(result);
                };
                return DocumentClosingEventDeferral;
            }());
            DiagnosticsHub.DocumentClosingEventDeferral = DocumentClosingEventDeferral;
            var DocumentClosingEventArgs = (function () {
                function DocumentClosingEventArgs(onHandlerCompleted) {
                    this._onHandlerCompleted = onHandlerCompleted;
                    this._eventDeferral = null;
                }
                Object.defineProperty(DocumentClosingEventArgs.prototype, "waitHandler", {
                    get: function () {
                        return this._eventDeferral !== null;
                    },
                    enumerable: true,
                    configurable: true
                });
                DocumentClosingEventArgs.prototype.getDeferral = function () {
                    if (this._eventDeferral === null) {
                        this._eventDeferral = new DocumentClosingEventDeferral(this._onHandlerCompleted);
                    }
                    return this._eventDeferral;
                };
                return DocumentClosingEventArgs;
            }());
            DiagnosticsHub.DocumentClosingEventArgs = DocumentClosingEventArgs;
            var Document = (function () {
                function Document() {
                    this._documentProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.DocumentPortMarshaler", {}, true);
                    this._logger = DiagnosticsHub.getLogger();
                }
                Document.prototype.getTools = function () {
                    return this._documentProxy._call("getTools");
                };
                Document.prototype.openInAlternateFormat = function (format) {
                    if (format === 1) {
                        this._logger.debug("Opening current document as a Vspx");
                        return this._documentProxy._call("openAsVspx");
                    }
                    throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1000"));
                };
                Document.prototype.isPerformanceDebuggerDocument = function () {
                    return this._documentProxy._call("isPerformanceDebuggerDocument");
                };
                return Document;
            }());
            var _currentDocument = null;
            function getCurrentDocument() {
                if (_currentDocument === null) {
                    _currentDocument = new Document();
                }
                return _currentDocument;
            }
            DiagnosticsHub.getCurrentDocument = getCurrentDocument;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var Telemetry;
            (function (Telemetry) {
                "use strict";
                (function (SelectionChangeSource) {
                    SelectionChangeSource[SelectionChangeSource["SwimLane"] = 0] = "SwimLane";
                    SelectionChangeSource[SelectionChangeSource["DoubleSlider"] = 1] = "DoubleSlider";
                    SelectionChangeSource[SelectionChangeSource["DoubleSliderHandles"] = 2] = "DoubleSliderHandles";
                })(Telemetry.SelectionChangeSource || (Telemetry.SelectionChangeSource = {}));
                var SelectionChangeSource = Telemetry.SelectionChangeSource;
                var CpuUsage = (function () {
                    function CpuUsage() {
                        this._serviceProxy = getTelemetryAnalysisService();
                    }
                    CpuUsage.prototype.jmcToggle = function (state) {
                        this._serviceProxy._post("reportJmcToggle", state);
                    };
                    CpuUsage.prototype.enabledAtStart = function (state) {
                        this._serviceProxy._post("cpuUsageEnabledInitially", state);
                    };
                    return CpuUsage;
                }());
                Telemetry.CpuUsage = CpuUsage;
                var PerformanceDebugger = (function () {
                    function PerformanceDebugger() {
                        this._serviceProxy = getTelemetryGlobalService();
                    }
                    PerformanceDebugger.prototype.selectToolsDropdown = function () {
                        this._serviceProxy._post("reportSelectToolsDropdown");
                    };
                    return PerformanceDebugger;
                }());
                Telemetry.PerformanceDebugger = PerformanceDebugger;
                var ViewportController = (function () {
                    function ViewportController() {
                        this._serviceProxy = getTelemetryAnalysisService();
                    }
                    ViewportController.prototype.zoomIn = function () {
                        this._serviceProxy._post("reportZoomIn");
                    };
                    ViewportController.prototype.zoomOut = function () {
                        this._serviceProxy._post("reportZoomOut");
                    };
                    ViewportController.prototype.resetZoom = function () {
                        this._serviceProxy._post("reportResetZoom");
                    };
                    ViewportController.prototype.clearSelection = function () {
                        this._serviceProxy._post("reportClearSelection");
                    };
                    ViewportController.prototype.selectionChanged = function (source, isMinSize, sourceId) {
                        var sourceGuid = sourceId || DiagnosticsHub.Guid.empty.toString();
                        this._serviceProxy._post("reportSelectionChanged", source, isMinSize, sourceGuid);
                    };
                    ViewportController.prototype.showGraphTooltip = function (swimlaneId) {
                        this._serviceProxy._post("reportGraphTooltip", swimlaneId);
                    };
                    return ViewportController;
                }());
                Telemetry.ViewportController = ViewportController;
                var CollectedData = (function () {
                    function CollectedData() {
                        this._serviceProxy = getTelemetryAnalysisService();
                    }
                    CollectedData.prototype.lostEvents = function (counter) {
                        this._serviceProxy._post("countLostEvents", counter);
                    };
                    return CollectedData;
                }());
                Telemetry.CollectedData = CollectedData;
                var _telemetryAnalysisServiceProxy = null;
                var _telemetryGlobalServiceProxy = null;
                function getTelemetryAnalysisService() {
                    if (_telemetryAnalysisServiceProxy === null) {
                        _telemetryAnalysisServiceProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.TelemetryAnalysisServiceMarshaler", {}, true);
                    }
                    return _telemetryAnalysisServiceProxy;
                }
                function getTelemetryGlobalService() {
                    if (_telemetryGlobalServiceProxy === null) {
                        _telemetryGlobalServiceProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.TelemetryGlobalServiceMarshaler", {}, true);
                    }
                    return _telemetryGlobalServiceProxy;
                }
            })(Telemetry = DiagnosticsHub.Telemetry || (DiagnosticsHub.Telemetry = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var SelectionTimeRangeChangedEvent = (function () {
                function SelectionTimeRangeChangedEvent() {
                    this._publisher = new DiagnosticsHub.Publisher([SelectionTimeRangeChangedEvent.EventName]);
                    this._eventAggregator = Microsoft.VisualStudio.DiagnosticsHub.getEventAggregator();
                    this._eventAggregator.addEventListener(SelectionTimeRangeChangedEvent.EventGlobalName, this.forwardSelectionTimeRangeEvent.bind(this));
                    this._timeRangeMarshaler = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.SwimlaneDataServiceMarshaler", {}, true);
                    if (!this._timeRangeMarshaler) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSProfiler.1007"));
                    }
                }
                SelectionTimeRangeChangedEvent.prototype.addEventListener = function (listener) {
                    this._publisher.addEventListener(SelectionTimeRangeChangedEvent.EventName, listener);
                };
                SelectionTimeRangeChangedEvent.prototype.removeEventListener = function (listener) {
                    this._publisher.removeEventListener(SelectionTimeRangeChangedEvent.EventName, listener);
                };
                SelectionTimeRangeChangedEvent.prototype.raiseEvent = function (eventArgs) {
                    var dto = {
                        i: eventArgs.isIntermittent
                    };
                    if (eventArgs.position) {
                        dto.ts = {
                            begin: eventArgs.position.begin.jsonValue,
                            end: eventArgs.position.end.jsonValue
                        };
                    }
                    this._eventAggregator.raiseEvent(SelectionTimeRangeChangedEvent.EventGlobalName, dto);
                };
                SelectionTimeRangeChangedEvent.prototype.getTimeRange = function () {
                    return this._timeRangeMarshaler._call("getCurrentTimeRange")
                        .then(function (time) {
                        if (time && time.begin && time.end) {
                            return new DiagnosticsHub.JsonTimespan(new DiagnosticsHub.BigNumber(time.begin.h, time.begin.l), new DiagnosticsHub.BigNumber(time.end.h, time.end.l));
                        }
                        return null;
                    });
                };
                SelectionTimeRangeChangedEvent.prototype.forwardSelectionTimeRangeEvent = function (dto) {
                    var selectionTimeRange;
                    if (typeof dto.ts !== "undefined") {
                        selectionTimeRange = new DiagnosticsHub.JsonTimespan(new DiagnosticsHub.BigNumber(dto.ts.begin.h, dto.ts.begin.l), new DiagnosticsHub.BigNumber(dto.ts.end.h, dto.ts.end.l));
                    }
                    var args = {
                        position: selectionTimeRange,
                        isIntermittent: dto.i
                    };
                    this._publisher.invokeListener(SelectionTimeRangeChangedEvent.EventName, args);
                };
                SelectionTimeRangeChangedEvent.EventGlobalName = "DiagnosticsHub.EventAggregator.SelectionTimeRangeChanged";
                SelectionTimeRangeChangedEvent.EventName = "DiagnosticsHub.SelectionTimeRangeChanged";
                return SelectionTimeRangeChangedEvent;
            }());
            var ChangeViewportEvent = (function () {
                function ChangeViewportEvent() {
                    this._publisher = new DiagnosticsHub.Publisher([ChangeViewportEvent.EventName]);
                    this._eventAggregator = Microsoft.VisualStudio.DiagnosticsHub.getEventAggregator();
                    this._eventAggregator.addEventListener(ChangeViewportEvent.EventGlobalName, this.forwardChangeViewportEvent.bind(this));
                }
                ChangeViewportEvent.prototype.addEventListener = function (listener) {
                    this._publisher.addEventListener(ChangeViewportEvent.EventName, listener);
                };
                ChangeViewportEvent.prototype.removeEventListener = function (listener) {
                    this._publisher.removeEventListener(ChangeViewportEvent.EventName, listener);
                };
                ChangeViewportEvent.prototype.raiseEvent = function (eventArgs) {
                    var dto = null;
                    if (eventArgs) {
                        dto = {
                            beginH: eventArgs.begin.jsonValue.h,
                            beginL: eventArgs.begin.jsonValue.l,
                            endH: eventArgs.end.jsonValue.h,
                            endL: eventArgs.end.jsonValue.l
                        };
                    }
                    this._eventAggregator.raiseEvent(ChangeViewportEvent.EventGlobalName, dto);
                };
                ChangeViewportEvent.prototype.forwardChangeViewportEvent = function (args) {
                    var eventArgs = null;
                    if (typeof args.beginH !== "undefined" &&
                        typeof args.beginL !== "undefined" &&
                        typeof args.endH !== "undefined" &&
                        typeof args.endL !== "undefined") {
                        eventArgs = new DiagnosticsHub.JsonTimespan(new DiagnosticsHub.BigNumber(args.beginH, args.beginL), new DiagnosticsHub.BigNumber(args.endH, args.endL));
                    }
                    this._publisher.invokeListener(ChangeViewportEvent.EventName, eventArgs);
                };
                ChangeViewportEvent.EventGlobalName = "DiagnosticsHub.EventAggregator.ChangeViewport";
                ChangeViewportEvent.EventName = "DiagnosticsHub.ChangeViewport";
                return ChangeViewportEvent;
            }());
            var JmcEnabledStateChangedEvent = (function () {
                function JmcEnabledStateChangedEvent() {
                    this._publisher = new DiagnosticsHub.Publisher([JmcEnabledStateChangedEvent.EventName]);
                    this._eventAggregator = Microsoft.VisualStudio.DiagnosticsHub.getEventAggregator();
                    this._eventAggregator.addEventListener(JmcEnabledStateChangedEvent.EventGlobalName, this.forwardJmcEnabledStateChangedEvent.bind(this));
                }
                JmcEnabledStateChangedEvent.prototype.addEventListener = function (listener) {
                    this._publisher.addEventListener(JmcEnabledStateChangedEvent.EventName, listener);
                };
                JmcEnabledStateChangedEvent.prototype.removeEventListener = function (listener) {
                    this._publisher.removeEventListener(JmcEnabledStateChangedEvent.EventName, listener);
                };
                JmcEnabledStateChangedEvent.prototype.raiseEvent = function (args) {
                    this._eventAggregator.raiseEvent(JmcEnabledStateChangedEvent.EventGlobalName, args);
                };
                JmcEnabledStateChangedEvent.prototype.forwardJmcEnabledStateChangedEvent = function (args) {
                    this._publisher.invokeListener(JmcEnabledStateChangedEvent.EventName, args);
                };
                JmcEnabledStateChangedEvent.EventGlobalName = "DiagnosticsHub.EventAggregator.JmcEnabledStateChanged";
                JmcEnabledStateChangedEvent.EventName = "DiagnosticsHub.JmcEnabledStateChanged";
                return JmcEnabledStateChangedEvent;
            }());
            var DetailsViewSelectionChangedEvent = (function () {
                function DetailsViewSelectionChangedEvent() {
                    this._publisher = new DiagnosticsHub.Publisher([DetailsViewSelectionChangedEvent.EventName]);
                    this._eventAggregator = Microsoft.VisualStudio.DiagnosticsHub.getEventAggregator();
                    this._eventAggregator.addEventListener(DetailsViewSelectionChangedEvent.EventGlobalName, this.forwardDetailsViewSelectionChangedEvent.bind(this));
                }
                DetailsViewSelectionChangedEvent.prototype.addEventListener = function (listener) {
                    this._publisher.addEventListener(DetailsViewSelectionChangedEvent.EventName, listener);
                };
                DetailsViewSelectionChangedEvent.prototype.removeEventListener = function (listener) {
                    this._publisher.removeEventListener(DetailsViewSelectionChangedEvent.EventName, listener);
                };
                DetailsViewSelectionChangedEvent.prototype.raiseEvent = function (args) {
                    this._eventAggregator.raiseEvent(DetailsViewSelectionChangedEvent.EventGlobalName, args);
                };
                DetailsViewSelectionChangedEvent.prototype.forwardDetailsViewSelectionChangedEvent = function (args) {
                    this._publisher.invokeListener(DetailsViewSelectionChangedEvent.EventName, args);
                };
                DetailsViewSelectionChangedEvent.EventGlobalName = "DiagnosticsHub.EventAggregator.DetailsViewSelectionChangedEvent";
                DetailsViewSelectionChangedEvent.EventName = "DiagnosticsHub.DetailsViewSelectionChangedEvent";
                return DetailsViewSelectionChangedEvent;
            }());
            var DetailsViewReadyEvent = (function () {
                function DetailsViewReadyEvent() {
                    this._publisher = new DiagnosticsHub.Publisher([DetailsViewReadyEvent.EventName]);
                    this._eventAggregator = Microsoft.VisualStudio.DiagnosticsHub.getEventAggregator();
                    this._eventAggregator.addEventListener(DetailsViewReadyEvent.EventGlobalName, this.forwardDetailsViewSelectionChangedEvent.bind(this));
                }
                DetailsViewReadyEvent.prototype.addEventListener = function (listener) {
                    this._publisher.addEventListener(DetailsViewReadyEvent.EventName, listener);
                };
                DetailsViewReadyEvent.prototype.removeEventListener = function (listener) {
                    this._publisher.removeEventListener(DetailsViewReadyEvent.EventName, listener);
                };
                DetailsViewReadyEvent.prototype.raiseEvent = function (args) {
                    this._eventAggregator.raiseEvent(DetailsViewReadyEvent.EventGlobalName, args);
                };
                DetailsViewReadyEvent.prototype.forwardDetailsViewSelectionChangedEvent = function (args) {
                    this._publisher.invokeListener(DetailsViewReadyEvent.EventName, args);
                };
                DetailsViewReadyEvent.EventGlobalName = "DiagnosticsHub.EventAggregator.DetailsViewReadyEvent";
                DetailsViewReadyEvent.EventName = "DiagnosticsHub.DetailsViewReadyEvent";
                return DetailsViewReadyEvent;
            }());
            var ViewEventManager = (function () {
                function ViewEventManager() {
                    this._selectionChanged = new SelectionTimeRangeChangedEvent();
                    this._changeViewport = new ChangeViewportEvent();
                    this._jmcEnabledStateChanged = new JmcEnabledStateChangedEvent();
                    this._detailsViewSelectionChangedEvent = new DetailsViewSelectionChangedEvent();
                    this._detailsViewReady = new DetailsViewReadyEvent();
                    this._detailsViewNavigationMarshaler = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.DetailsViewNavigationMarshaler", {}, true);
                }
                Object.defineProperty(ViewEventManager.prototype, "selectionChanged", {
                    get: function () {
                        return this._selectionChanged;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(ViewEventManager.prototype, "changeViewport", {
                    get: function () {
                        return this._changeViewport;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(ViewEventManager.prototype, "jmcEnabledStateChanged", {
                    get: function () {
                        return this._jmcEnabledStateChanged;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(ViewEventManager.prototype, "detailsViewSelectionChanged", {
                    get: function () {
                        return this._detailsViewSelectionChangedEvent;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(ViewEventManager.prototype, "detailsViewReady", {
                    get: function () {
                        return this._detailsViewReady;
                    },
                    enumerable: true,
                    configurable: true
                });
                ViewEventManager.prototype.selectDetailsView = function (guid) {
                    return this._detailsViewNavigationMarshaler._call("selectDetailsView", guid);
                };
                return ViewEventManager;
            }());
            var _viewEventManager = null;
            function getViewEventManager() {
                if (_viewEventManager === null) {
                    _viewEventManager = new ViewEventManager();
                }
                return _viewEventManager;
            }
            DiagnosticsHub.getViewEventManager = getViewEventManager;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var ErrorCodes = (function () {
                function ErrorCodes() {
                }
                ErrorCodes.VSHUB_E_INVALID_REGEX = 0xE111E001;
                return ErrorCodes;
            }());
            DiagnosticsHub.ErrorCodes = ErrorCodes;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var HostController = (function () {
                function HostController(sessionId, controllerId) {
                    this._sessionId = sessionId;
                    this._controllerId = controllerId;
                    this._dataWarehouseRegistryService = new Microsoft.VisualStudio.DiagnosticsHub.Controllers.DataWarehouseRegistryService();
                }
                HostController.prototype.request = function (actionId, requestData) {
                    var _this = this;
                    if (this._host) {
                        return this._host.request(this._controllerId, actionId, this._sessionId, requestData);
                    }
                    else {
                        var isPerfDebugger = this.ensureIsPerformanceDebuggerDocument();
                        var isDataWarehouseInVsHub = this.ensureDataWarehouseInVsHub();
                        return Microsoft.Plugin.Promise.join([isPerfDebugger, isDataWarehouseInVsHub])
                            .then(function (results) {
                            if (!results) {
                                throw new Error("Unable to determine host for request");
                            }
                            var isExternalHost = false;
                            results.forEach(function (result) {
                                isExternalHost = isExternalHost || result;
                            });
                            return getHost(isExternalHost).then(function (host) {
                                _this._host = host;
                                return _this._host.request(_this._controllerId, actionId, _this._sessionId, requestData);
                            });
                        });
                    }
                };
                HostController.prototype.requestSync = function (actionId, requestData) {
                    if (!this._host) {
                        this._host = getHostSync(false);
                    }
                    return this._host.requestSync(this._controllerId, actionId, this._sessionId, requestData);
                };
                HostController.prototype.ensureIsPerformanceDebuggerDocument = function () {
                    if (Microsoft.Plugin.F12) {
                        return Microsoft.Plugin.Promise.wrap(false);
                    }
                    else {
                        return DiagnosticsHub.getCurrentDocument().isPerformanceDebuggerDocument();
                    }
                };
                HostController.prototype.ensureDataWarehouseInVsHub = function () {
                    if (Microsoft.Plugin.F12) {
                        return Microsoft.Plugin.Promise.wrap(false);
                    }
                    else {
                        return this._dataWarehouseRegistryService.isDataWarehouseInVsHub();
                    }
                };
                return HostController;
            }());
            DiagnosticsHub.HostController = HostController;
            var _host = null;
            function getHost(isExternalHost) {
                if (!_host) {
                    if (isExternalHost) {
                        var serviceHubHost = new DiagnosticsHub.DataWarehouseServiceHubHost();
                        return serviceHubHost.initialize().then(function () {
                            _host = serviceHubHost;
                            return _host;
                        });
                    }
                    else {
                        _host = new DiagnosticsHub.DataWarehouseNativeHost(DiagnosticsHub.getLogger());
                    }
                }
                return Microsoft.Plugin.Promise.wrap(_host);
            }
            function getHostSync(isExternalHost) {
                if (!_host) {
                    if (isExternalHost) {
                        _host = new DiagnosticsHub.DataWarehouseServiceHubHost();
                    }
                    else {
                        _host = new DiagnosticsHub.DataWarehouseNativeHost(DiagnosticsHub.getLogger());
                    }
                }
                return _host;
            }
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));

// SIG // Begin signature block
// SIG // MIIkEwYJKoZIhvcNAQcCoIIkBDCCJAACAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // dJkKjBuYmnovVRTYEFHV51P4n96jty9pZ682CfjCID+g
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFdgwghXUAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggcQwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIMTGYRM2rKtiRAxELX+z3EqfjZi9fcW9NxaKYNZn
// SIG // uEvsMFgGCisGAQQBgjcCAQwxSjBIoC6ALABEAGkAYQBn
// SIG // AG4AbwBzAHQAaQBjAHMASAB1AGIALgBJAG0AcABsAC4A
// SIG // agBzoRaAFGh0dHA6Ly9taWNyb3NvZnQuY29tMA0GCSqG
// SIG // SIb3DQEBAQUABIIBAKPRGIqUWiU12KuTPUI6Gi0iVsxy
// SIG // bdDgdPpUZUgEIKftik1PLWyAAkrqytfV4kqhx892R3JJ
// SIG // MgUXOCWolyJJ4HB4/itVBcOYo8Z4UpsYbg28S3PluyX2
// SIG // MMmvnrjweXLAPfuXsBhDTxj+etvzIo/OwQWDYbLIWMi0
// SIG // r8CA90oojrOPgzAWx14NCc6zj3W9vOKHKVWc6SReQsgl
// SIG // iIbixgil0dpuQu9A47aXXtr1J1zu9MGcBg7PU+IZjaG+
// SIG // Svn5w8DMZIfW+2lsu/EcHvDTkCujaMajOSttCvQ0IYZe
// SIG // 2FsjNU0v65Y3JB+xZag4Mz4oxhANvSoFp639dmHYyv9R
// SIG // oXrzeJ2hghNMMIITSAYKKwYBBAGCNwMDATGCEzgwghM0
// SIG // BgkqhkiG9w0BBwKgghMlMIITIQIBAzEPMA0GCWCGSAFl
// SIG // AwQCAQUAMIIBPAYLKoZIhvcNAQkQAQSgggErBIIBJzCC
// SIG // ASMCAQEGCisGAQQBhFkKAwEwMTANBglghkgBZQMEAgEF
// SIG // AAQgUKhvuxGvRxhlm1WDHtQdwm6h28VI5XshxHC/8SmO
// SIG // 60YCBliLqr/BYxgSMjAxNzAyMDkwMzQzMzMuODFaMAcC
// SIG // AQGAAgH0oIG5pIG2MIGzMQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVy
// SIG // IERTRSBFU046QjhFQy0zMEE0LTcxNDQxJTAjBgNVBAMT
// SIG // HE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Wggg7Q
// SIG // MIIGcTCCBFmgAwIBAgIKYQmBKgAAAAAAAjANBgkqhkiG
// SIG // 9w0BAQsFADCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEyMDAG
// SIG // A1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUg
// SIG // QXV0aG9yaXR5IDIwMTAwHhcNMTAwNzAxMjEzNjU1WhcN
// SIG // MjUwNzAxMjE0NjU1WjB8MQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQ
// SIG // Q0EgMjAxMDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC
// SIG // AQoCggEBAKkdDbx3EYo6IOz8E5f1+n9plGt0VBDVpQoA
// SIG // goX77XxoSyxfxcPlYcJ2tz5mK1vwFVMnBDEfQRsalR3O
// SIG // CROOfGEwWbEwRA/xYIiEVEMM1024OAizQt2TrNZzMFcm
// SIG // gqNFDdDq9UeBzb8kYDJYYEbyWEeGMoQedGFnkV+BVLHP
// SIG // k0ySwcSmXdFhE24oxhr5hoC732H8RsEnHSRnEnIaIYqv
// SIG // S2SJUGKxXf13Hz3wV3WsvYpCTUBR0Q+cBj5nf/VmwAOW
// SIG // RH7v0Ev9buWayrGo8noqCjHw2k4GkbaICDXoeByw6ZnN
// SIG // POcvRLqn9NxkvaQBwSAJk3jN/LzAyURdXhacAQVPIk0C
// SIG // AwEAAaOCAeYwggHiMBAGCSsGAQQBgjcVAQQDAgEAMB0G
// SIG // A1UdDgQWBBTVYzpcijGQ80N7fEYbxTNoWoVtVTAZBgkr
// SIG // BgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8EBAMC
// SIG // AYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAWgBTV
// SIG // 9lbLj+iiXGJo0T2UkFvXzpoYxDBWBgNVHR8ETzBNMEug
// SIG // SaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXRfMjAxMC0w
// SIG // Ni0yMy5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsGAQUF
// SIG // BzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NlcnRzL01pY1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNy
// SIG // dDCBoAYDVR0gAQH/BIGVMIGSMIGPBgkrBgEEAYI3LgMw
// SIG // gYEwPQYIKwYBBQUHAgEWMWh0dHA6Ly93d3cubWljcm9z
// SIG // b2Z0LmNvbS9QS0kvZG9jcy9DUFMvZGVmYXVsdC5odG0w
// SIG // QAYIKwYBBQUHAgIwNB4yIB0ATABlAGcAYQBsAF8AUABv
// SIG // AGwAaQBjAHkAXwBTAHQAYQB0AGUAbQBlAG4AdAAuIB0w
// SIG // DQYJKoZIhvcNAQELBQADggIBAAfmiFEN4sbgmD+BcQM9
// SIG // naOhIW+z66bM9TG+zwXiqf76V20ZMLPCxWbJat/15/B4
// SIG // vceoniXj+bzta1RXCCtRgkQS+7lTjMz0YBKKdsxAQEGb
// SIG // 3FwX/1z5Xhc1mCRWS3TvQhDIr79/xn/yN31aPxzymXlK
// SIG // kVIArzgPF/UveYFl2am1a+THzvbKegBvSzBEJCI8z+0D
// SIG // pZaPWSm8tv0E4XCfMkon/VWvL/625Y4zu2JfmttXQOnx
// SIG // zplmkIz/amJ/3cVKC5Em4jnsGUpxY517IW3DnKOiPPp/
// SIG // fZZqkHimbdLhnPkd/DjYlPTGpQqWhqS9nhquBEKDuLWA
// SIG // myI4ILUl5WTs9/S/fmNZJQ96LjlXdqJxqgaKD4kWumGn
// SIG // Ecua2A5HmoDF0M2n0O99g/DhO3EJ3110mCIIYdqwUB5v
// SIG // vfHhAN/nMQekkzr3ZUd46PioSKv33nJ+YWtvd6mBy6cJ
// SIG // rDm77MbL2IK0cs0d9LiFAR6A+xuJKlQ5slvayA1VmXqH
// SIG // czsI5pgt6o3gMy4SKfXAL1QnIffIrE7aKLixqduWsqdC
// SIG // osnPGUFN4Ib5KpqjEWYw07t0MkvfY3v1mYovG8chr1m1
// SIG // rtxEPJdQcdeh0sVV42neV8HR3jDA/czmTfsNv11P6Z0e
// SIG // GTgvvM9YBS7vDaBQNdrvCScc1bN+NR4Iuto229Nfj950
// SIG // iEkSMIIE2jCCA8KgAwIBAgITMwAAAJ9n8rWoIwZbewAA
// SIG // AAAAnzANBgkqhkiG9w0BAQsFADB8MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EgMjAxMDAeFw0xNjA5MDcxNzU2NDdaFw0x
// SIG // ODA5MDcxNzU2NDdaMIGzMQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVy
// SIG // IERTRSBFU046QjhFQy0zMEE0LTcxNDQxJTAjBgNVBAMT
// SIG // HE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2UwggEi
// SIG // MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC5CPEj
// SIG // nN3EAi8ChaGjJ5dk+QOcElQ/U4JauD7rfW4YxXLBJ9Vw
// SIG // KQzwlkvWj4THFjlinvuxDSOEouMw99J1UAvT2dDQ7vqS
// SIG // vV1fNzn4xnIRZCszgUXXToabEJMRYDBd0Xy0zVwBKn35
// SIG // zWkXl8LVVJIhhCb1uipgAYscz9GnlFZiejB5yZ5qPkym
// SIG // XaFZe3IOk2OiwqM3vxeq4Tl5ovz91/yt4x7ZgGsS/Tru
// SIG // d44w4DuUY8bemRGpnRLBhdklmesB+g5oPRuomT8YMPpo
// SIG // zg8EXi+o8Iex9l4bL86BTK0hETMyCH9niRgDPQtBkdAW
// SIG // R8kbYte0Ki+U2grlj4zMUyl1+A5ZAgMBAAGjggEbMIIB
// SIG // FzAdBgNVHQ4EFgQU/YsbIsN9I0d2ph7f4GbUUum2+aAw
// SIG // HwYDVR0jBBgwFoAU1WM6XIoxkPNDe3xGG8UzaFqFbVUw
// SIG // VgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljVGlt
// SIG // U3RhUENBXzIwMTAtMDctMDEuY3JsMFoGCCsGAQUFBwEB
// SIG // BE4wTDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5taWNy
// SIG // b3NvZnQuY29tL3BraS9jZXJ0cy9NaWNUaW1TdGFQQ0Ff
// SIG // MjAxMC0wNy0wMS5jcnQwDAYDVR0TAQH/BAIwADATBgNV
// SIG // HSUEDDAKBggrBgEFBQcDCDANBgkqhkiG9w0BAQsFAAOC
// SIG // AQEAZRDBbGvPFR6vD0g2698tC7wAAOaRZhpQlmW5MQ9l
// SIG // jKnxdMvH55b4G/O+M/LM/EGcwcgpmNYx8h03PfGXpM+y
// SIG // 9mOUgDVCGvI8lN+nOuApOX2Oj3vYVANURv9cz/nqtPNH
// SIG // IVDwhds3s4X8Ls/Tm9KGzuuAcFtBmYGGM9YY7KvgwZEg
// SIG // gUVefa8hac4CkcIVhfKrl7Rw6YpoicfnbNlWUsBFZP0E
// SIG // WO6S7lL3nTfD+Qzbi2mkcN6CXLNlsYdo1kuU/GNyXr1K
// SIG // Nyt1U7Rz4tiAViEpBBu0zpzRFHFFwzBkjnmdu5Ljxcyp
// SIG // A1W7c78BFXqZBq7GdVvtcbg2D0NW9wTBvAu/R6GCA3kw
// SIG // ggJhAgEBMIHjoYG5pIG2MIGzMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lw
// SIG // aGVyIERTRSBFU046QjhFQy0zMEE0LTcxNDQxJTAjBgNV
// SIG // BAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Wi
// SIG // JQoBATAJBgUrDgMCGgUAAxUAbNMnCPL52ajL+RnekktK
// SIG // rdsZo8GggcIwgb+kgbwwgbkxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBo
// SIG // ZXIgTlRTIEVTTjo1N0Y2LUMxRTAtNTU0QzErMCkGA1UE
// SIG // AxMiTWljcm9zb2Z0IFRpbWUgU291cmNlIE1hc3RlciBD
// SIG // bG9jazANBgkqhkiG9w0BAQUFAAIFANxGNQYwIhgPMjAx
// SIG // NzAyMDkwMDIzMzRaGA8yMDE3MDIxMDAwMjMzNFowdzA9
// SIG // BgorBgEEAYRZCgQBMS8wLTAKAgUA3EY1BgIBADAKAgEA
// SIG // AgIFwgIB/zAHAgEAAgIYczAKAgUA3EeGhgIBADA2Bgor
// SIG // BgEEAYRZCgQCMSgwJjAMBgorBgEEAYRZCgMBoAowCAIB
// SIG // AAIDFuNgoQowCAIBAAIDB6EgMA0GCSqGSIb3DQEBBQUA
// SIG // A4IBAQCjYV5Tag3qlWH0baVQwGyfSwAM9ZKQANe7Mz3c
// SIG // 2Ya/B61g1EiMjGNWQCBUxN9tE2gD26wPuOIAE6Pt1F7K
// SIG // WlL7iCZfjbVcsTZtDlsQD6yjKSFCKk+zJUf61zA1wLqq
// SIG // yynKtfORKHNyFWFR+NgJJbYKUzYX0UJ3U+H3dS2Hq6VU
// SIG // AmYRTKIjtLhBxnurKXL/w6Juwq0NQ6vZjUZAvE8k2Z6W
// SIG // 03VCPSN4UDH66xWrcqOxCuvw/vpq4bDpQ+oc1PBFvEEP
// SIG // AnybnK3pA5xld2j0nNB7dD44rz96Am56fVWoxGv7Wh+D
// SIG // I42J29ATHSsCT307vkIsrKnwuYP0t1vOeEPF1+cwMYIC
// SIG // 9TCCAvECAQEwgZMwfDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx
// SIG // HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEm
// SIG // MCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENB
// SIG // IDIwMTACEzMAAACfZ/K1qCMGW3sAAAAAAJ8wDQYJYIZI
// SIG // AWUDBAIBBQCgggEyMBoGCSqGSIb3DQEJAzENBgsqhkiG
// SIG // 9w0BCRABBDAvBgkqhkiG9w0BCQQxIgQgmS9FXhs+DMzH
// SIG // NI81mfLphcjCyUGcopOYky1pZX77y94wgeIGCyqGSIb3
// SIG // DQEJEAIMMYHSMIHPMIHMMIGxBBRs0ycI8vnZqMv5Gd6S
// SIG // S0qt2xmjwTCBmDCBgKR+MHwxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xJjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1w
// SIG // IFBDQSAyMDEwAhMzAAAAn2fytagjBlt7AAAAAACfMBYE
// SIG // FNNfL7K7Z9ceYtZ59YVyXKyaHROiMA0GCSqGSIb3DQEB
// SIG // CwUABIIBAK2kNDX52tf/mUulIZ5KzPkn/Bj3NdldEQZ/
// SIG // c/5BF+DFQSKoIa76QpSgRAPpZ7LtQoTBKcekc4IEby/E
// SIG // m2OYpSRcd7xTqEVmtgCF9PbZWXGEHMJelwwPFn5I0efv
// SIG // aQzOaeWqdd4cmVL8d92mM8c8W37flPmrvLNO1J3G1WSR
// SIG // 1vPmt2t8GzBQZmnMVhvZ3alIDZa4ewormv7ieZaHlZON
// SIG // utym5YrVq7rtcivsFkEtwfrCqabAHV6PaqBz/3SI6dW5
// SIG // meMfDSb31hgwA0/8F/6yO6bK0YNfnODtidkxxWliYkVU
// SIG // vFlF1Bsmdq5hL1ae2fcjQUtQMpTpFCJGo/fAfwpcll8=
// SIG // End signature block
